/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputVerifier;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import rma.lang.Modifiable;
import rma.lang.ModifiedEventControl;
import rma.swing.EditableComponent;
import rma.swing.FormManagementListener;
import rma.swing.RmaJTable;
import rma.swing.RmaValidComponent;
import rma.swing.ToolTipWindow;
import rma.swing.text.RmaDocument;
import rma.util.RMAUtil;

public class RmaJTextField
extends JTextField
implements DocumentListener,
RmaValidComponent,
FocusListener,
MouseMotionListener,
FormManagementListener,
Modifiable,
ModifiedEventControl,
EditableComponent {
    private boolean _modified = false;
    private boolean _ignoreModifiedEvents;
    Color _changeColor = null;
    boolean _emptyOk = true;
    boolean _showError = true;
    protected RmaJTable _minMaxTable = null;
    protected int _minMaxTableCol = -1;
    protected JTextComponent _statusLine = null;
    protected String _statusText = null;
    protected String _name = null;
    protected Window _parentWindow = null;
    protected boolean _modifiable = true;
    protected boolean _trimTxt = false;
    protected boolean _trimTrailingWhiteSpaceTxt = false;
    private static final Color DISABLED_COLOR;
    private boolean _showingErrorMessage = false;
    private boolean _forwardModifiedEvents = true;
    private ToolTipWindow _tooltipwindow;
    private List<Action> _popupActions;
    private boolean _displayMsgInQueue = true;
    private UndoManager _undoMgr;

    public static void removeAWTEnterKeyCompatibility() {
        if (!Boolean.getBoolean("TextField.KeepEnterKey")) {
            RmaJTextField f = new RmaJTextField();
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            Keymap map = f.getKeymap();
            map.removeKeyStrokeBinding(enter);
        }
    }

    public RmaJTextField(String text, int columns) {
        super(text, columns);
        this.setToolTipText("");
        this.createListeners();
    }

    public RmaJTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.setToolTipText("");
        this.createListeners();
    }

    public RmaJTextField(int columns) {
        super(columns);
        this.setToolTipText("");
        this.createListeners();
    }

    public RmaJTextField() {
        this.setToolTipText("");
        this.createListeners();
    }

    public RmaJTextField(String text) {
        super(text);
        this.setToolTipText("");
        this.createListeners();
    }

    private void createListeners() {
        Caret caret = this.getCaret();
        if (caret != null) {
            caret.setBlinkRate(0);
        }
        this.addFocusListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    RmaJTextField.this.popupMenuAction(e.getPoint());
                }
            }
        });
        if (Boolean.getBoolean("TextFieldUseRemoveListener")) {
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RmaJTextField.this.setModified(true);
                        }
                    });
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
        }
        if (Boolean.getBoolean("TextField.additionalInfo")) {
            AbstractAction toolTipAction = new AbstractAction("ToolTipWindow"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RmaJTextField.this.showToolTipWindow();
                }
            };
            this.getInputMap(0).put(KeyStroke.getKeyStroke(113, 0), "tooltipwindow");
            this.getActionMap().put("tooltipwindow", toolTipAction);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.isTemporary()) {
                        return;
                    }
                    if (RmaJTextField.this._tooltipwindow == null) {
                        return;
                    }
                    Component c2 = e.getOppositeComponent();
                    if (c2 == null) {
                        return;
                    }
                    Window w = SwingUtilities.windowForComponent(c2);
                    if (w != RmaJTextField.this._tooltipwindow) {
                        RmaJTextField.this._tooltipwindow.setVisible(false);
                    }
                }
            });
        }
        this._undoMgr = new UndoManager();
        this.getDocument().addUndoableEditListener(this._undoMgr);
        UndoAction undoAction = new UndoAction();
        RedoAction redoAction = new RedoAction();
        this.registerKeyboardAction(undoAction, KeyStroke.getKeyStroke(90, 2), 0);
        this.registerKeyboardAction(redoAction, KeyStroke.getKeyStroke(89, 2), 0);
    }

    protected void showToolTipWindow() {
        String ttText = super.getToolTipText();
        if (ttText == null || ttText.length() == 0) {
            return;
        }
        if (this._tooltipwindow == null) {
            this._tooltipwindow = new ToolTipWindow(this, ttText){

                @Override
                public void setVisible(boolean visible) {
                    super.setVisible(visible);
                    if (!visible) {
                        RmaJTextField.this._tooltipwindow = null;
                    }
                }
            };
        }
    }

    protected void popupMenuAction(Point pt) {
        JPopupMenu popup = new JPopupMenu();
        boolean editable = this.isEditable() && this.isEnabled();
        boolean hasSelection = this.getSelectedText() != null;
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = e.getSource();
                if (!(obj instanceof JMenuItem)) {
                    return;
                }
                JMenuItem mi = (JMenuItem)obj;
                String name = mi.getName();
                if ("cut".equals(name)) {
                    RmaJTextField.this.cut();
                } else if ("copy".equals(name)) {
                    RmaJTextField.this.copy();
                } else if ("paste".equals(name)) {
                    RmaJTextField.this.paste();
                } else if ("selectall".equals(name)) {
                    RmaJTextField.this.selectAll();
                }
            }
        };
        if (editable && hasSelection) {
            JMenuItem cutMenu = new JMenuItem("Cut");
            cutMenu.setName("cut");
            cutMenu.addActionListener(listener);
            popup.add(cutMenu);
        }
        if (hasSelection) {
            JMenuItem copyMenu = new JMenuItem("Copy");
            copyMenu.setName("copy");
            copyMenu.addActionListener(listener);
            popup.add(copyMenu);
        }
        if (editable) {
            JMenuItem pasteMenu = new JMenuItem("Paste");
            pasteMenu.setName("paste");
            pasteMenu.addActionListener(listener);
            popup.add(pasteMenu);
        }
        popup.addSeparator();
        JMenuItem selectMenu = new JMenuItem("Select All");
        selectMenu.setName("selectall");
        selectMenu.addActionListener(listener);
        popup.add(selectMenu);
        if (this._popupActions != null) {
            popup.addSeparator();
            for (int i = 0; i < this._popupActions.size(); ++i) {
                popup.add(this._popupActions.get(i));
            }
        }
        popup.show(this, pt.x, pt.y);
    }

    public void addPopupAction(Action action) {
        if (action != null) {
            if (this._popupActions == null) {
                this._popupActions = new ArrayList<Action>();
            }
            this._popupActions.add(action);
        }
    }

    @Override
    public void replaceSelection(String content) {
        super.replaceSelection(content);
        this.setModified(true);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (b && this.isEditable()) {
            this.setBackground(UIManager.getColor("TextField.background"));
        } else {
            this.setBackground(DISABLED_COLOR);
        }
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(b);
        if (b && this.isEnabled()) {
            this.setBackground(UIManager.getColor("TextField.background"));
        } else {
            this.setBackground(DISABLED_COLOR);
        }
    }

    public void setChangeColor(Color changeColor) {
        if (changeColor == null) {
            this.getDocument().removeDocumentListener(this);
        } else {
            if (this._changeColor == null) {
                this.getDocument().addDocumentListener(this);
            }
            this._changeColor = changeColor;
        }
    }

    @Override
    public void setDocument(Document doc) {
        if (doc == null) {
            return;
        }
        super.setDocument(doc);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this._changeColor != null) {
            this.setForeground(this._changeColor);
        }
        this.setModified(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this._changeColor != null) {
            this.setForeground(this._changeColor);
        }
        this.setModified(true);
    }

    public void setEmptyOk(boolean b) {
        boolean oldValue = this._emptyOk;
        this._emptyOk = b;
        this.firePropertyChange("emptyOk", oldValue, this._emptyOk);
    }

    public boolean isEmptyOk() {
        return this._emptyOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorMsg(String msg) {
        if (!this._showError) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        RmaJTextField rmaJTextField = this;
        synchronized (rmaJTextField) {
            if (this._showingErrorMessage) {
                return;
            }
            this._showingErrorMessage = true;
            this.notify();
        }
        final String m = msg;
        if (this._parentWindow == null) {
            this._parentWindow = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        }
        if (this.displayMsgInQueue()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RmaJTextField.this.displayMsg(m);
                }
            });
        } else {
            this.displayMsg(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void displayMsg(String msg) {
        RmaJTextField c2 = this;
        if (this.isEnabled() && this.isShowing()) {
            InputVerifier iv = this.getInputVerifier();
            this.setInputVerifier(null);
            Object title = "";
            if (this.getName() != null) {
                title = this.getName() + " Field";
            }
            JOptionPane.showMessageDialog(c2, msg, (String)title, 0);
            this.setInputVerifier(iv);
        }
        RmaJTextField rmaJTextField = this;
        synchronized (rmaJTextField) {
            this._showingErrorMessage = false;
            this.notify();
        }
    }

    protected boolean displayMsgInQueue() {
        return this._displayMsgInQueue;
    }

    public void setDisplayMsgInQueue(boolean displayInQueue) {
        this._displayMsgInQueue = displayInQueue;
    }

    public void takeFocus() {
        final RmaJTextField c2 = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                c2.requestFocus();
            }
        });
    }

    @Override
    public boolean isValid(boolean showErr) {
        return this.validateData(showErr);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.isTemporary() || this.getParent() instanceof JTable) {
            return;
        }
        Container c2 = this.getParent();
        if (c2 == null) {
            return;
        }
        if (c2.isVisible()) {
            this.validateData(true);
        }
    }

    public void setTrimWhiteSpace(boolean b) {
        this._trimTxt = b;
    }

    public void setTrimTrailingWhiteSpace(boolean b) {
        this._trimTrailingWhiteSpaceTxt = b;
    }

    public void setShowErrorMsg(boolean b) {
        this._showError = b;
    }

    protected boolean validateData(boolean showErrorMsg) {
        return true;
    }

    public void setMinMaxTable(RmaJTable tbl, int col) {
        this._minMaxTable = tbl;
        this._minMaxTableCol = col;
        if (this._minMaxTable != null) {
            this._minMaxTable.addTableMinMaxTracker(this._minMaxTableCol);
        }
    }

    public void setStatusLineField(JTextComponent statusLine, String statusText) {
        if (statusLine == null) {
            this.removeMouseMotionListener(this);
            statusText = null;
        } else if (this._statusText != null && this._statusText.length() > 0) {
            this.addMouseMotionListener(this);
            this._statusLine = statusLine;
            this._statusText = statusText;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getID() == 504) {
            this._statusLine.setText(this._statusText);
        } else if (e.getID() == 505) {
            this._statusLine.setText("");
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (e.isAltDown() && e.isControlDown() && e.isShiftDown()) {
            return "<html><b>Class:</b>" + this.getClass().getName() + "<br><b>Enabled:</b>" + this.isEnabled() + "<br><b>Editable:</b>" + this.isEditable() + "<br><b>Name:</b>" + this.getName() + "<br><b>Text:</b>" + this.getText() + "</html>";
        }
        return super.getToolTipText(e);
    }

    @Override
    public String getToolTipText() {
        String superToolTip = super.getToolTipText();
        if (superToolTip == null || superToolTip.length() == 0) {
            String text = this.getText();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            if (fm.stringWidth(text) > this.getWidth()) {
                return text;
            }
        }
        return this.fixToolTip(superToolTip);
    }

    protected String fixToolTip(String superToolTip) {
        if (superToolTip == null || superToolTip.length() == 0) {
            return superToolTip;
        }
        if (Boolean.getBoolean("TextField.additionalInfo")) {
            if (superToolTip.startsWith("<")) {
                if (superToolTip.endsWith(">")) {
                    superToolTip = superToolTip.substring(0, superToolTip.length() - 6);
                }
                superToolTip = superToolTip.concat("<br><br><hr><br><center>Press F2 for more info</center></html>");
                return superToolTip;
            }
            superToolTip = "<html>".concat(superToolTip).concat("<br><br><hr><br>Press F2 for more info</html>");
        }
        return superToolTip;
    }

    @Override
    public void clearPerformed() {
        this.setText("");
        if (this._undoMgr != null) {
            this._undoMgr.discardAllEdits();
        }
    }

    @Override
    public String getText() {
        String txt = super.getText();
        if (this._trimTxt) {
            return txt.trim();
        }
        if (this._trimTrailingWhiteSpaceTxt) {
            return txt.replaceFirst("\\s+$", "");
        }
        return txt;
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean b) {
        if (this._ignoreModifiedEvents) {
            return;
        }
        this._modified = b;
        if (!b && this.getForeground().equals(this._changeColor)) {
            this.setForeground(UIManager.getColor("TextField.foreground"));
        }
        if (b && this.forwardModifiedEvents()) {
            RMAUtil.setParentModified(this);
        }
    }

    public boolean forwardModifiedEvents() {
        return this.getForwardModifiedEvents();
    }

    @Override
    public boolean getForwardModifiedEvents() {
        return this._forwardModifiedEvents;
    }

    @Override
    public void setFowardModifiedEvents(boolean b) {
        this._forwardModifiedEvents = b;
    }

    public static final boolean isCursorKey(int keyCode) {
        return keyCode == 39 || keyCode == 37 || keyCode == 38 || keyCode == 40 || keyCode == 35 || keyCode == 36 || keyCode == 18 || keyCode == 20 || keyCode == 17 || keyCode == 16 || keyCode == 144 || keyCode == 33 || keyCode == 34;
    }

    @Override
    public void setIsEditable(boolean b) {
        if (this._modifiable) {
            this.setEditable(b);
        }
    }

    public void setModifiable(boolean b) {
        this._modifiable = b;
    }

    public void setMaxLength(int length) {
        Document doc = this.getDocument();
        if (doc instanceof RmaDocument) {
            ((RmaDocument)doc).setLength(length);
        }
    }

    public int getMaxLength() {
        Document doc = this.getDocument();
        if (doc instanceof RmaDocument) {
            return ((RmaDocument)doc).getLength();
        }
        return -1;
    }

    public void setUppercaseOnly(boolean upperOnly) {
        Document doc = this.getDocument();
        if (doc instanceof RmaDocument) {
            ((RmaDocument)doc).setUppercase();
        }
    }

    public void setLowercaseOnly(boolean lowerOnly) {
        Document doc = this.getDocument();
        if (doc instanceof RmaDocument) {
            ((RmaDocument)doc).setLowercase();
        }
    }

    @Override
    public void setIgnoreModifiedEvents(boolean ignore) {
        this._ignoreModifiedEvents = ignore;
    }

    public boolean isIgnoringModifiedEvents() {
        return this.getIgnoreModifiedEvents();
    }

    @Override
    public boolean getIgnoreModifiedEvents() {
        return this._ignoreModifiedEvents;
    }

    @Override
    protected Document createDefaultModel() {
        return new RmaDocument();
    }

    static {
        Font f;
        DISABLED_COLOR = UIManager.getColor("TextField.disabledBackground");
        if (UIManager.getFont("NumericField.font") == null && (f = UIManager.getFont("TextField.font")) != null) {
            Font font = new Font("monospaced", 0, f.getSize());
            UIManager.put("NumericField.font", font);
        }
    }

    public class UndoAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                RmaJTextField.this._undoMgr.undo();
            }
            catch (CannotUndoException e) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public class RedoAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                RmaJTextField.this._undoMgr.redo();
            }
            catch (CannotRedoException e) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

