/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class RmaJWrappingLabel
extends JComponent
implements SwingConstants {
    protected String text = "";
    protected int align;

    public RmaJWrappingLabel() {
        this("");
    }

    public RmaJWrappingLabel(String s) {
        this(s, 2);
    }

    public RmaJWrappingLabel(String s, int a) {
        this.setText(s);
        this.setTextAlignment(a);
        this.setForeground(UIManager.getColor("Label.foreground"));
    }

    public int getTextAlignment() {
        return this.align;
    }

    public void setTextAlignment(int newAlignStyle) {
        if (this.align != newAlignStyle) {
            this.align = newAlignStyle;
            this.repaint();
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        if (!this.text.equals(newText)) {
            this.text = newText;
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Graphics g = this.getGraphics();
        if (g == null) {
            return null;
        }
        int fromIndex = 0;
        Dimension d = new Dimension();
        d.width = this.getWidth();
        int boundx = this.getWidth();
        Font f = this.getFont();
        if (f == null) {
            this.setFont(UIManager.getFont("TextField.font"));
        }
        FontMetrics fm = this.getToolkit().getFontMetrics(this.getFont());
        int baseline = fm.getMaxAscent();
        while (fromIndex < this.text.length() && this.text.charAt(fromIndex) == ' ' && ++fromIndex < this.text.length()) {
        }
        if (fm.stringWidth(this.getText()) <= this.getWidth()) {
            d.height = fm.getHeight() + 4;
            return d;
        }
        StringTokenizer tok = new StringTokenizer(this.getText(), " ", true);
        Object last = "";
        String current = null;
        int lines = 1;
        while (tok.hasMoreElements()) {
            current = (String)tok.nextElement();
            if (fm.stringWidth((String)last) + fm.stringWidth(current) > d.width) {
                ++lines;
                last = current;
                continue;
            }
            last = (String)last + current;
        }
        d.height = lines * fm.getHeight() + 4;
        d.width = this.getWidth();
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.text != null) {
            int fromIndex = 0;
            int pos = 0;
            FontMetrics fm = this.getToolkit().getFontMetrics(this.getFont());
            int baseline = fm.getMaxAscent();
            Dimension d = this.getSize();
            int boundx = this.getWidth();
            int boundy = this.getHeight();
            int x = 0;
            int y = 0;
            while (y + fm.getHeight() <= boundy && fromIndex != -1) {
                String s;
                while (fromIndex < this.text.length() && this.text.charAt(fromIndex) == ' ' && ++fromIndex < this.text.length()) {
                }
                pos = fromIndex;
                int bestpos = -1;
                String largestString = null;
                while (pos >= fromIndex && fm.stringWidth(s = (pos = this.text.indexOf(32, pos)) == -1 ? this.text.substring(fromIndex) : this.text.substring(fromIndex, pos)) < boundx) {
                    largestString = s;
                    bestpos = pos;
                    if (pos == -1) break;
                    ++pos;
                }
                if (largestString == null) {
                    int totalWidth = 0;
                    int oneCharWidth = 0;
                    for (pos = fromIndex; pos < this.text.length() && totalWidth + (oneCharWidth = fm.charWidth(this.text.charAt(pos))) < boundx; ++pos) {
                        totalWidth += oneCharWidth;
                    }
                    this.drawAlignedString(g, fm, baseline, this.text.substring(fromIndex, pos), x, y, boundx);
                    fromIndex = pos;
                } else {
                    this.drawAlignedString(g, fm, baseline, largestString, x, y, boundx);
                    fromIndex = bestpos;
                }
                y += fm.getHeight();
            }
            fm = null;
        }
    }

    protected void drawAlignedString(Graphics g, FontMetrics fm, int baseline, String s, int x, int y, int width) {
        int drawx = x;
        int drawy = y + baseline;
        if (this.align != 2) {
            int sw = fm.stringWidth(s);
            if (this.align == 0) {
                drawx += (width - sw) / 2;
            } else if (this.align == 4) {
                drawx = drawx + width - sw;
            }
        }
        g.setColor(this.getForeground());
        g.drawString(s, drawx, drawy);
    }
}

