/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.TreeNode;
import org.jdesktop.swingx.JXComboBox;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableModel;
import rma.lang.Modifiable;
import rma.swing.FormManagementListener;
import rma.swing.RmaJComboBox;
import rma.swing.table.ComboBoxRenderer;
import rma.swing.table.MleHeadRenderer;
import rma.swing.table.RmaCellEditor;
import rma.swing.treeTable.PathCellEditor;
import rma.swing.treeTable.PathCellRenderer;
import rma.util.RMAUtil;

public class RmaJXTreeTable
extends JXTreeTable
implements MouseListener,
ItemListener,
FormManagementListener,
Modifiable {
    private boolean _modified;
    private MleHeadRenderer _mleheadrend;
    private boolean _alternatingReportBackground;
    private Color _alternatingReportBackgroundColor;
    protected Hashtable<Integer, Color> _rowForeground = new Hashtable();
    private boolean _addedToScrollPane;
    private JScrollPane _scrollPane;

    public RmaJXTreeTable() {
        this.init();
    }

    public RmaJXTreeTable(TreeTableModel model) {
        super(model);
        this.init();
    }

    protected void init() {
        this._scrollPane = this.createScrollPane();
        this.setToolTipText("");
    }

    protected JScrollPane createScrollPane() {
        return new JScrollPane();
    }

    public String getToolTipText(MouseEvent event) {
        Point p = event.getPoint();
        int column = this.columnAtPoint(p);
        int row = this.rowAtPoint(p);
        Object obj = this.getValueAt(row, column);
        if (event.isControlDown() && event.isShiftDown() && obj != null) {
            return "<html>Object at " + row + ", " + column + " is a<br> " + obj.getClass().getName() + "@" + System.identityHashCode(obj) + "<br>\"" + obj.toString() + "\"</html>";
        }
        if (obj != null) {
            return obj.toString();
        }
        return super.getToolTipText(event);
    }

    public JScrollPane getScrollPane() {
        Container parent = this.getParent();
        if (parent == null) {
            this._scrollPane.setViewportView((Component)((Object)this));
            this._addedToScrollPane = true;
            return this._scrollPane;
        }
        if (parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            JScrollPane sp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, viewport);
            if (sp == null) {
                this._scrollPane.setViewportView((Component)((Object)this));
                this._addedToScrollPane = true;
                return this._scrollPane;
            }
            this._scrollPane = sp;
        }
        return this._scrollPane;
    }

    public JComboBox setComboBoxEditor(int col, Vector<Object> data) {
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        JXComboBox cb = new JXComboBox(data);
        return this.setComboBoxEditor(tc, cb);
    }

    public JComboBox setComboBoxEditor(int col, Object[] data) {
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        JXComboBox cb = new JXComboBox(data);
        return this.setComboBoxEditor(tc, cb);
    }

    private JComboBox setComboBoxEditor(TableColumn tc, JXComboBox cb) {
        cb.setBorder(null);
        cb.addMouseListener((MouseListener)this);
        cb.addItemListener((ItemListener)this);
        cb.getEditor().getEditorComponent().addMouseListener(this);
        RmaCellEditor dcf = new RmaCellEditor((JComboBox)cb);
        dcf.setClickCountToStart(1);
        tc.setCellRenderer(new ComboBoxRenderer());
        tc.setCellEditor(dcf);
        return cb;
    }

    public JComboBox setComboBoxRowEditor(TreeNode node, int col, Vector data) {
        if (node == null) {
            return null;
        }
        TableColumnModel tcm = this.getColumnModel();
        if (col >= tcm.getColumnCount() || col < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        JXComboBox cb = new JXComboBox(data);
        cb.setBorder(null);
        cb.addItemListener((ItemListener)this);
        cb.addMouseListener((MouseListener)this);
        cb.getEditor().getEditorComponent().addMouseListener(this);
        TableCellEditor tce = tc.getCellEditor();
        RmaCellEditor dcf = new RmaCellEditor((JComboBox)cb);
        dcf.setClickCountToStart(1);
        if (tce instanceof PathCellEditor) {
            ((PathCellEditor)tce).add(node, dcf);
        } else {
            if (tce == null) {
                tce = new RmaCellEditor(new RmaJComboBox());
            }
            PathCellEditor rce = new PathCellEditor(tce, (JXTreeTable)this);
            tc.setCellEditor(rce);
            rce.add(node, dcf);
            rce.setClickCountToStart(1);
        }
        ComboBoxRenderer cellRenderer = new ComboBoxRenderer();
        TableCellRenderer tcr = tc.getCellRenderer();
        if (tcr instanceof PathCellRenderer) {
            PathCellRenderer rcr = (PathCellRenderer)tcr;
            rcr.add(node, cellRenderer);
        } else {
            PathCellRenderer rcr = new PathCellRenderer(tcr);
            tc.setCellRenderer(rcr);
            rcr.add(node, cellRenderer);
        }
        dcf.setClickCountToStart(1);
        return cb;
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        this.setModified(true);
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean modified) {
        this._modified = modified;
        if (modified) {
            RMAUtil.setParentModified((Component)((Object)this));
        }
    }

    @Override
    public void clearPerformed() {
        this.commitEdit(true);
        this.clearCells();
    }

    public void clearCells() {
        for (int c2 = 0; c2 < this.getColumnCount(); ++c2) {
            Object empty = this.getClearedCellValue(c2);
            for (int r = 0; r < this.getRowCount(); ++r) {
                try {
                    this.setValueAt(empty, r, c2);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("clearCells:" + e);
                    System.out.println("clearCells:" + this.getColumnModel().getColumn(c2).getHeaderValue());
                    System.out.println("clearCells:row=" + r + " col=" + c2);
                    RowSorter rs = this.getRowSorter();
                    if (rs instanceof TableRowSorter) {
                        TableRowSorter trs = (TableRowSorter)rs;
                        TableModel model = (TableModel)trs.getModel();
                        System.out.println("clearCells:sorter model max row=" + model.getRowCount() + " max col=" + model.getColumnCount());
                    }
                    System.out.println("clearCells:model max row=" + this.getModel().getRowCount() + " max col=" + this.getModel().getColumnCount());
                    e.printStackTrace();
                }
            }
        }
        this.revalidate();
        this.repaint();
    }

    public boolean commitEdit(boolean commit) {
        if (!this.isEditing()) {
            return true;
        }
        TableCellEditor dce = this.getCellEditor();
        if (dce == null) {
            return true;
        }
        if (commit) {
            return dce.stopCellEditing();
        }
        dce.cancelCellEditing();
        return true;
    }

    protected Object getClearedCellValue(int col) {
        return "";
    }

    public MleHeadRenderer setMlHeaderRenderer() {
        this._mleheadrend = new MleHeadRenderer();
        TableColumnModel tcm = this.getTableHeader().getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            tc.setHeaderRenderer(this._mleheadrend);
        }
        return this._mleheadrend;
    }

    public void setColumnWidths(int ... widths) {
        if (widths == null || widths.length == 0) {
            return;
        }
        for (int i = 0; i < widths.length; ++i) {
            this.setColumnWidth(i, widths[i]);
        }
    }

    public void setColumnWidth(int colNum, int width) {
        if (colNum >= this.getColumnCount()) {
            return;
        }
        TableColumn tc = this.getColumnModel().getColumn(colNum);
        if (tc == null) {
            System.out.println("setColumnWidth(): TableColumn at col " + colNum + " is null");
            return;
        }
        if (width == -1) {
            Object obj = tc.getHeaderValue();
            if (obj instanceof String) {
                String st = (String)obj;
                int newWidth = st.length() * 5;
                tc.setPreferredWidth(newWidth);
            }
        } else {
            tc.setPreferredWidth(width);
        }
    }

    public void setAlternatingReportBackground(boolean b) {
        this._alternatingReportBackground = b;
    }

    public boolean getAlternatingReportBackground() {
        return this._alternatingReportBackground;
    }

    public void setAlternatingReportBackgroundColor(Color color) {
        this._alternatingReportBackgroundColor = color;
    }

    public Color getAlternatingReportBackgroundColor() {
        return this._alternatingReportBackgroundColor;
    }

    public void setRowForeground(int rowNum, Color rfColor) {
        if (rfColor == null) {
            this._rowForeground.remove(new Integer(rowNum));
            return;
        }
        this._rowForeground.put(new Integer(rowNum), rfColor);
    }

    public Color getRowForeground(int rowNum) {
        Color color = this._rowForeground.get(new Integer(rowNum));
        if (color == null) {
            return this.getForeground();
        }
        return color;
    }
}

