/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.event.RecordSelectorListener;

public class RmaNavigationPanel
extends JPanel
implements ItemListener,
ListDataListener,
PropertyChangeListener {
    RecordSelectorListener _rl = null;
    private int _recCount;
    private int _currentRec;
    JPanel jPanelPgCounter = new JPanel();
    JButton jB_GoStart = new NavButton();
    JButton jB_GoBack = new NavButton();
    JLabel jL_Counter = new JLabel();
    JButton jB_GoForward = new NavButton();
    JButton jB_GoEnd = new NavButton();
    JComboBox _combo;

    public RmaNavigationPanel() {
        this.jL_Counter.setBorder(new BevelBorder(0));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(new GridBagLayout());
        this.jB_GoStart.setActionCommand("0");
        this.jB_GoBack.setActionCommand("1");
        this.jB_GoForward.setActionCommand("2");
        this.jB_GoEnd.setActionCommand("3");
        this.jB_GoStart.setToolTipText("First Record");
        this.jB_GoBack.setToolTipText("Previous Record");
        this.jB_GoForward.setToolTipText("Next Record");
        this.jB_GoEnd.setToolTipText("Last Record");
        Insets zeroInsets = RmaInsets.insets(0, 0, 0, 0);
        this.add((Component)this.jB_GoStart, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, zeroInsets, 0, 0));
        this.add((Component)this.jB_GoBack, new RmaGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, zeroInsets, 0, 0));
        this.add((Component)this.jL_Counter, new RmaGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, zeroInsets, 0, 0));
        this.add((Component)this.jB_GoForward, new RmaGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, zeroInsets, 0, 0));
        this.add((Component)this.jB_GoEnd, new RmaGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, zeroInsets, 0, 0));
        String filenameup = "Images/startbuttonup.gif";
        ImageIcon uIcon = RmaImage.getImageIcon(filenameup);
        Insets i = new Insets(0, 0, 0, 0);
        filenameup = "Images/skipBack.gif";
        uIcon = RmaImage.getImageIcon(filenameup);
        this.jB_GoStart.setIcon(uIcon);
        this.jB_GoStart.setMargin(i);
        filenameup = "Images/stepBack.gif";
        uIcon = RmaImage.getImageIcon(filenameup);
        this.jB_GoBack.setIcon(uIcon);
        this.jB_GoBack.setMargin(i);
        filenameup = "Images/stepForward.gif";
        uIcon = RmaImage.getImageIcon(filenameup);
        this.jB_GoForward.setIcon(uIcon);
        this.jB_GoForward.setMargin(i);
        filenameup = "Images/skipForward.gif";
        uIcon = RmaImage.getImageIcon(filenameup);
        this.jB_GoEnd.setIcon(uIcon);
        this.jB_GoEnd.setMargin(i);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = e.getSource();
                if (obj instanceof AbstractButton) {
                    AbstractButton button = (AbstractButton)obj;
                    String cmdStr = button.getActionCommand();
                    int cmd = -1;
                    try {
                        cmd = Integer.parseInt(cmdStr);
                        RmaNavigationPanel.this.notifyListeners(cmd);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        };
        this.jB_GoStart.addActionListener(al);
        this.jB_GoBack.addActionListener(al);
        this.jB_GoForward.addActionListener(al);
        this.jB_GoEnd.addActionListener(al);
    }

    public void setCounterToolTipText(String txt) {
        this.jL_Counter.setToolTipText(txt);
    }

    public RecordSelectorListener addRecordSelectorListener(RecordSelectorListener rl) {
        RecordSelectorListener oldRl = this._rl;
        this._rl = rl;
        return oldRl;
    }

    public void previousRecord() {
        if (this.jB_GoBack.isEnabled()) {
            this.notifyListeners(1);
        }
    }

    public void nextRecord() {
        if (this.jB_GoForward.isEnabled()) {
            this.notifyListeners(2);
        }
    }

    public void lastRecord() {
        if (this.jB_GoEnd.isEnabled()) {
            this.notifyListeners(3);
        }
    }

    public void firstRecord() {
        if (this.jB_GoStart.isEnabled()) {
            this.notifyListeners(0);
        }
    }

    void notifyListeners(int cmd) {
        if (this._rl == null && this._combo == null) {
            return;
        }
        int pos = 0;
        boolean newRecord = false;
        switch (cmd) {
            case 0: {
                pos = 0;
                break;
            }
            case 1: {
                if (this._currentRec - 1 < 0) {
                    pos = 0;
                    break;
                }
                pos = this._currentRec - 1;
                break;
            }
            case 2: {
                if (this._currentRec + 1 >= this._recCount - 1) {
                    pos = this._recCount - 1;
                    break;
                }
                pos = this._currentRec + 1;
                break;
            }
            case 3: {
                pos = this.getLastPosition() - 1;
                break;
            }
            case 4: {
                newRecord = this.newRecord();
                break;
            }
            default: {
                return;
            }
        }
        if (this._rl != null && !newRecord && this._rl.selectRecord(pos)) {
            this.updateDisplay(pos);
        }
        if (this._combo != null && pos > -1 && pos < this._combo.getItemCount()) {
            this._combo.setSelectedIndex(pos);
        }
    }

    private boolean newRecord() {
        boolean retn = false;
        if (this._rl == null) {
            return retn;
        }
        if (this._rl.newRecord()) {
            this.setNewRecord(true);
            retn = true;
        }
        return retn;
    }

    public void setNumRecords(int recNum) {
        this._recCount = recNum;
    }

    public void setRecordPosition(int current) {
        this._currentRec = current;
    }

    public void setNewRecord(boolean newRec) {
        if (newRec) {
            this.jL_Counter.setText("New");
        } else {
            this.updateDisplay(this._currentRec);
        }
    }

    private int getLastPosition() {
        return this._recCount;
    }

    private void updateDisplay(int pos) {
        this._currentRec = pos;
        int displayRecNo = 0;
        if (this.getLastPosition() > 0) {
            displayRecNo = this._currentRec + 1;
        }
        this.jL_Counter.setText(" " + displayRecNo + " of " + this.getLastPosition() + " ");
    }

    public void fillForm(int curr, int recNum) {
        this.setNumRecords(recNum);
        this.setRecordPosition(curr);
        this.updateDisplay(curr);
        if (this.getLastPosition() == 0) {
            // empty if block
        }
    }

    public void fillForm(JComboBox combo) {
        if (combo == null) {
            return;
        }
        if (this._combo != null) {
            this._combo.removeItemListener(this);
            this._combo.getModel().removeListDataListener(this);
            this._combo.removePropertyChangeListener("model", this);
        }
        this._combo = combo;
        this.setNumRecords(combo.getItemCount());
        this.setRecordPosition(combo.getSelectedIndex());
        this.updateDisplay(combo.getSelectedIndex());
        combo.addItemListener(this);
        combo.getModel().addListDataListener(this);
        combo.addPropertyChangeListener("model", this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            return;
        }
        if (e.getSource() == this._combo && this._combo != null) {
            int pos = this._combo.getSelectedIndex();
            this.setRecordPosition(pos);
            this.updateDisplay(pos);
        }
    }

    private void updateComboInfo() {
        if (this._combo == null) {
            return;
        }
        this.setNumRecords(this._combo.getItemCount());
        int pos = this._combo.getSelectedIndex();
        this.setRecordPosition(pos);
        this.updateDisplay(pos);
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.updateComboInfo();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.updateComboInfo();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.updateComboInfo();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("model") && this._combo != null) {
            AbstractListModel oldModel = (AbstractListModel)e.getOldValue();
            oldModel.removeListDataListener(this);
            this._combo.getModel().addListDataListener(this);
            this.updateComboInfo();
        }
    }

    public class NavButton
    extends JButton {
        @Override
        public Dimension getPreferredSize() {
            Dimension dd = super.getPreferredSize();
            Dimension d = RmaNavigationPanel.this.jL_Counter.getPreferredSize();
            dd.height = d.height;
            return dd;
        }
    }
}

