/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.NumberFormatter;
import rma.swing.RmaSpinnerNumberModel;

public class RmaSpinnerNumberEditor
extends JSpinner.DefaultEditor {
    private static String getDefaultPattern(Locale locale) {
        return "#,##0.###;-#,##0.###";
    }

    public RmaSpinnerNumberEditor(JSpinner spinner) {
        this(spinner, RmaSpinnerNumberEditor.getDefaultPattern(spinner.getLocale()));
    }

    public RmaSpinnerNumberEditor(JSpinner spinner, String decimalFormatPattern) {
        this(spinner, new DecimalFormat(decimalFormatPattern));
    }

    private RmaSpinnerNumberEditor(JSpinner spinner, DecimalFormat format) {
        super(spinner);
        if (!(spinner.getModel() instanceof RmaSpinnerNumberModel)) {
            throw new IllegalArgumentException("model not a SpinnerNumberModel");
        }
        RmaSpinnerNumberModel model = (RmaSpinnerNumberModel)spinner.getModel();
        RmaNumberEditorFormatter formatter = new RmaNumberEditorFormatter(model, format);
        DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter);
        JFormattedTextField ftf = this.getTextField();
        ftf.setEditable(true);
        ftf.setFormatterFactory(factory);
        ftf.setHorizontalAlignment(4);
        try {
            String maxString = ((InternationalFormatter)formatter).valueToString(model.getMinimum());
            String minString = ((InternationalFormatter)formatter).valueToString(model.getMaximum());
            ftf.setColumns(Math.max(maxString.length(), minString.length()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public DecimalFormat getFormat() {
        return (DecimalFormat)((NumberFormatter)this.getTextField().getFormatter()).getFormat();
    }

    public SpinnerNumberModel getModel() {
        return (SpinnerNumberModel)this.getSpinner().getModel();
    }

    private static class RmaNumberEditorFormatter
    extends NumberFormatter {
        private final RmaSpinnerNumberModel model;

        RmaNumberEditorFormatter(RmaSpinnerNumberModel model, NumberFormat format) {
            super(format);
            this.model = model;
            this.setValueClass(model.getValueClass());
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            String str = super.valueToString(value);
            return str;
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            Object stringToValue = null;
            if (text != null && !text.isEmpty()) {
                stringToValue = super.stringToValue(text);
            }
            return stringToValue;
        }

        public void setMinimum(Comparable min) {
            this.model.setMinimum(min);
        }

        public Comparable getMinimum() {
            return this.model.getMinimum();
        }

        public void setMaximum(Comparable max) {
            this.model.setMaximum(max);
        }

        public Comparable getMaximum() {
            return this.model.getMaximum();
        }
    }
}

