/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import javax.swing.AbstractSpinnerModel;

public class RmaSpinnerNumberModel
extends AbstractSpinnerModel {
    private Number stepSize;
    private Number value;
    private Comparable minimum;
    private Comparable maximum;
    private Number defaultValue;

    public RmaSpinnerNumberModel(Number defaultValue, Comparable minimum, Comparable maximum, Number stepSize) {
        if (minimum == null || maximum == null || minimum.compareTo(maximum) >= 0) {
            throw new IllegalArgumentException("(minimum <= maximum) is false");
        }
        if (stepSize == null) {
            throw new IllegalArgumentException("Null step size");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Null default value");
        }
        this.minimum = minimum;
        this.maximum = maximum;
        this.stepSize = stepSize;
        this.defaultValue = defaultValue;
    }

    public RmaSpinnerNumberModel(int defaultValue, int minimum, int maximum, int stepSize) {
        this(new Integer(defaultValue), new Integer(minimum), new Integer(maximum), new Integer(stepSize));
    }

    public RmaSpinnerNumberModel(double defaultValue, double minimum, double maximum, double stepSize) {
        this(new Double(defaultValue), new Double(minimum), new Double(maximum), new Double(stepSize));
    }

    public void setMinimum(Comparable minimum) {
        if (minimum == null ? this.minimum != null : !minimum.equals(this.minimum)) {
            this.minimum = minimum;
            this.fireStateChanged();
        }
    }

    public Comparable getMinimum() {
        return this.minimum;
    }

    public void setMaximum(Comparable maximum) {
        if (maximum == null ? this.maximum != null : !maximum.equals(this.maximum)) {
            this.maximum = maximum;
            this.fireStateChanged();
        }
    }

    public Comparable getMaximum() {
        return this.maximum;
    }

    public void setStepSize(Number stepSize) {
        if (stepSize == null) {
            throw new IllegalArgumentException("null stepSize");
        }
        if (!stepSize.equals(this.stepSize)) {
            this.stepSize = stepSize;
            this.fireStateChanged();
        }
    }

    public Number getStepSize() {
        return this.stepSize;
    }

    private Number incrValue(int dir) {
        Number newValue;
        if (this.value == null) {
            return this.defaultValue;
        }
        Number incrValue = this.value;
        if (incrValue instanceof Float || incrValue instanceof Double) {
            double v = incrValue.doubleValue() + this.stepSize.doubleValue() * (double)dir;
            newValue = incrValue instanceof Double ? (Number)new Double(v) : (Number)new Float(v);
        } else {
            long v = incrValue.longValue() + this.stepSize.longValue() * (long)dir;
            newValue = incrValue instanceof Long ? (Number)new Long(v) : (Number)(incrValue instanceof Integer ? (Number)new Integer((int)v) : (Number)(incrValue instanceof Short ? (Number)new Short((short)v) : (Number)new Byte((byte)v)));
        }
        if (this.maximum != null && this.maximum.compareTo(newValue) < 0) {
            return null;
        }
        if (this.minimum != null && this.minimum.compareTo(newValue) > 0) {
            return null;
        }
        return newValue;
    }

    @Override
    public Object getNextValue() {
        return this.incrValue(1);
    }

    @Override
    public Object getPreviousValue() {
        return this.incrValue(-1);
    }

    public Number getNumber() {
        return this.value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (this.value == null && value == null) {
            return;
        }
        if (this.value == null && value != null) {
            this.value = (Number)value;
            this.fireStateChanged();
        } else if (!this.value.equals(value)) {
            this.value = (Number)value;
            this.fireStateChanged();
        }
    }

    public Class<? extends Number> getValueClass() {
        return this.stepSize.getClass();
    }
}

