/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import rma.util.RMAIO;

public class RmaSteppedComboBox
extends JComboBox {
    protected int _popupWidth;

    public RmaSteppedComboBox(ComboBoxModel aModel) {
        super(aModel);
        this.setCorrectUI();
    }

    public RmaSteppedComboBox(Object[] items) {
        super(items);
        this.setCorrectUI();
    }

    public RmaSteppedComboBox(Vector items) {
        super(items);
        this.setCorrectUI();
    }

    protected void setCorrectUI() {
        this._popupWidth = 0;
        String laf = UIManager.getLookAndFeel().getClass().getName();
        boolean sysLaf = UIManager.getSystemLookAndFeelClassName().equals(laf);
        if (RMAIO.getOSType() == 1 && sysLaf) {
            this.setUI(new WindowsSteppedComboBoxUI());
        } else {
            this.setUI(new MetalSteppedComboBoxUI());
        }
    }

    public void setPopupWidth(int width) {
        this._popupWidth = width;
    }

    public Dimension getPopupSize() {
        Dimension cursize = this.getSize();
        if (this._popupWidth < 1) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            ComboBoxModel model = this.getModel();
            int size = model.getSize();
            int width = 0;
            for (int i = 0; i < size; ++i) {
                Object obj = model.getElementAt(i);
                if (obj == null) continue;
                int strWidth = obj instanceof JComponent ? ((JComponent)obj).getPreferredSize().width : fm.stringWidth(obj.toString());
                width = Math.max(strWidth, width);
            }
            this._popupWidth = width + 5;
        }
        this._popupWidth = Math.max(this._popupWidth, this.getWidth());
        return new Dimension(this._popupWidth, cursize.height);
    }

    class WindowsSteppedComboBoxUI
    extends BasicComboBoxUI {
        WindowsSteppedComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup popup = new BasicComboPopup(this.comboBox){

                @Override
                public void show() {
                    Dimension popupSize = ((RmaSteppedComboBox)this.comboBox).getPopupSize();
                    popupSize.setSize(popupSize.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                    Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
                    this.scroller.setMaximumSize(popupBounds.getSize());
                    this.scroller.setPreferredSize(popupBounds.getSize());
                    this.scroller.setMinimumSize(popupBounds.getSize());
                    this.list.invalidate();
                    int selectedIndex = this.comboBox.getSelectedIndex();
                    if (selectedIndex == -1) {
                        this.list.clearSelection();
                    } else {
                        this.list.setSelectedIndex(selectedIndex);
                    }
                    this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
                    this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
                    this.show(this.comboBox, popupBounds.x, popupBounds.y);
                }
            };
            popup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return popup;
        }
    }

    class MetalSteppedComboBoxUI
    extends MetalComboBoxUI {
        MetalSteppedComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup popup = new BasicComboPopup(this.comboBox){

                @Override
                public void show() {
                    Dimension popupSize = ((RmaSteppedComboBox)this.comboBox).getPopupSize();
                    popupSize.setSize(popupSize.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                    Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
                    this.scroller.setMaximumSize(popupBounds.getSize());
                    this.scroller.setPreferredSize(popupBounds.getSize());
                    this.scroller.setMinimumSize(popupBounds.getSize());
                    this.list.invalidate();
                    int selectedIndex = this.comboBox.getSelectedIndex();
                    if (selectedIndex == -1) {
                        this.list.clearSelection();
                    } else {
                        this.list.setSelectedIndex(selectedIndex);
                    }
                    this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
                    this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
                    this.show(this.comboBox, popupBounds.x, popupBounds.y);
                }
            };
            popup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return popup;
        }
    }
}

