/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.RmaImage;
import rma.swing.VCRControlsListener;
import rma.util.VCRDebug;

public class RmaVcrControls
extends JPanel
implements VCRControlsListener {
    private Vector _listenerList = new Vector();
    private int _min = 0;
    private int _max = 0;
    private ChangeListener _cl;
    private boolean _showTicMarks = false;
    private JButton rewindButton;
    private JToggleButton pauseButton;
    private JButton stopButton;
    private JButton playButton;
    private JButton fastForwardButton;
    private JButton skipForwardButton;
    private JButton stepForwardButton;
    private JButton stepBackButton;
    private JSlider slider;
    private JLabel startLabel;
    private JLabel endLabel;
    private JLabel noDataLabel;
    private JLabel currentLocation;
    private EventRunner _runner;

    public RmaVcrControls() {
        this.setLayout(new GridBagLayout());
        Insets marginInsets = new Insets(0, 0, 0, 0);
        Insets buttonInsets = new Insets(2, 0, 0, 0);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.insets = buttonInsets;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)buttonPanel, gbc);
        ImageIcon icon = RmaImage.getImageIcon("Images/skipBackUp.gif");
        if (icon == null) {
            System.out.println("Failed to load skipBackUp.gif");
        }
        this.rewindButton = new JButton(icon);
        this.rewindButton.setPressedIcon(RmaImage.getImageIcon("Images/skipBackDown.gif"));
        this.rewindButton.setBorder(null);
        this.rewindButton.setMargin(marginInsets);
        this.rewindButton.setActionCommand("0");
        this.rewindButton.setToolTipText("Skip to begining");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = buttonInsets;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        buttonPanel.add((Component)this.rewindButton, gbc);
        icon = RmaImage.getImageIcon("Images/stepBackUp.gif");
        if (icon == null) {
            System.out.println("Failed to load stepBackUp.gif");
        }
        this.stepBackButton = new JButton(icon);
        this.stepBackButton.setPressedIcon(RmaImage.getImageIcon("Images/stepBackDown.gif"));
        this.stepBackButton.setBorder(null);
        this.stepBackButton.setMargin(marginInsets);
        this.stepBackButton.setActionCommand("7");
        this.stepBackButton.setToolTipText("Step Back");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = buttonInsets;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        buttonPanel.add((Component)this.stepBackButton, gbc);
        icon = RmaImage.getImageIcon("Images/pauseUp.gif");
        if (icon == null) {
            System.out.println("Failed to load pauseUp.gif");
        }
        this.pauseButton = new JToggleButton(icon);
        icon = RmaImage.getImageIcon("Images/pauseDown.gif");
        this.pauseButton.setSelectedIcon(icon);
        this.pauseButton.setBorder(null);
        this.pauseButton.setMargin(marginInsets);
        this.pauseButton.setActionCommand("1");
        this.pauseButton.setToolTipText("Pause");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.insets = buttonInsets;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        buttonPanel.add((Component)this.pauseButton, gbc);
        icon = RmaImage.getImageIcon("Images/stopUp.gif");
        if (icon == null) {
            System.out.println("Failed to load stopUp.gif");
        }
        this.stopButton = new JButton(icon);
        this.stopButton.setPressedIcon(RmaImage.getImageIcon("Images/stopDown.gif"));
        this.stopButton.setBorder(null);
        this.stopButton.setMargin(marginInsets);
        this.stopButton.setActionCommand("3");
        this.stopButton.setToolTipText("Stop");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.insets = buttonInsets;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        buttonPanel.add((Component)this.stopButton, gbc);
        icon = RmaImage.getImageIcon("Images/forwardbuttonup.gif");
        if (icon == null) {
            System.out.println("Failed to load forwardbuttonup.gif");
        }
        this.playButton = new JButton(icon);
        this.playButton.setPressedIcon(RmaImage.getImageIcon("Images/forwardbuttondown.gif"));
        this.playButton.setBorder(null);
        this.playButton.setMargin(marginInsets);
        this.playButton.setActionCommand("4");
        this.playButton.setToolTipText("Play");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.insets = buttonInsets;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        buttonPanel.add((Component)this.playButton, gbc);
        icon = RmaImage.getImageIcon("Images/stepForwardUp.gif");
        if (icon == null) {
            System.out.println("Failed to load stepForwardUp.gif");
        }
        this.stepForwardButton = new JButton(icon);
        this.stepForwardButton.setPressedIcon(RmaImage.getImageIcon("Images/stepForwardDown.gif"));
        this.stepForwardButton.setBorder(null);
        this.stepForwardButton.setMargin(marginInsets);
        this.stepForwardButton.setActionCommand("8");
        this.stepForwardButton.setToolTipText("Step Forward");
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 2;
        gbc.insets = buttonInsets;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        buttonPanel.add((Component)this.stepForwardButton, gbc);
        icon = RmaImage.getImageIcon("Images/fastForwardUp.gif");
        if (icon == null) {
            System.out.println("Failed to load fastForwardUp.gif");
        }
        this.fastForwardButton = new JButton(icon);
        this.fastForwardButton.setPressedIcon(RmaImage.getImageIcon("Images/fastForwardDown.gif"));
        this.fastForwardButton.setBorder(null);
        this.fastForwardButton.setMargin(marginInsets);
        this.fastForwardButton.setActionCommand("5");
        this.fastForwardButton.setToolTipText("Fast Forward");
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 2;
        gbc.insets = buttonInsets;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        buttonPanel.add((Component)this.fastForwardButton, gbc);
        icon = RmaImage.getImageIcon("Images/skipForwardUp.gif");
        if (icon == null) {
            System.out.println("Failed to load skipForwardUp.gif");
        }
        this.skipForwardButton = new JButton(icon);
        this.skipForwardButton.setPressedIcon(RmaImage.getImageIcon("Images/skipForwardDown.gif"));
        this.skipForwardButton.setBorder(null);
        this.skipForwardButton.setMargin(marginInsets);
        this.skipForwardButton.setActionCommand("9");
        this.skipForwardButton.setToolTipText("Skip to End");
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 2;
        gbc.insets = buttonInsets;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        buttonPanel.add((Component)this.skipForwardButton, gbc);
        this.currentLocation = new JLabel();
        this.currentLocation.setHorizontalAlignment(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.insets = buttonInsets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.currentLocation, gbc);
        this.startLabel = new JLabel();
        Font f = this.startLabel.getFont();
        Font smallerFont = new Font(f.getName(), f.getStyle(), f.getSize() - 2);
        this.startLabel.setFont(smallerFont);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = buttonInsets;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        this.add((Component)this.startLabel, gbc);
        this.endLabel = new JLabel();
        this.endLabel.setFont(smallerFont);
        this.endLabel.setHorizontalAlignment(4);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = buttonInsets;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        this.add((Component)this.endLabel, gbc);
        this.noDataLabel = new JLabel(" (No Data)");
        this.noDataLabel.setFont(smallerFont);
        this.slider = new JSlider(){

            @Override
            public String getToolTipText(MouseEvent e) {
                if (VCRDebug.debug) {
                    return String.valueOf(this.getValue()).concat(" of ").concat(String.valueOf(this.getMaximum()));
                }
                return String.valueOf(this.getValue());
            }
        };
        this.slider.setToolTipText("");
        this.slider.setMinimum(0);
        this.slider.setMaximum(1);
        this.slider.setPaintTrack(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.insets = buttonInsets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.slider, gbc);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = e.getSource();
                if (obj instanceof AbstractButton) {
                    AbstractButton button = (AbstractButton)obj;
                    String cmdStr = button.getActionCommand();
                    int cmd = -1;
                    try {
                        cmd = Integer.parseInt(cmdStr);
                        if (button == RmaVcrControls.this.pauseButton && !RmaVcrControls.this.pauseButton.isSelected()) {
                            cmd = 2;
                        }
                        if (RmaVcrControls.this.pauseButton.isSelected() && (cmd == 4 || cmd == 5)) {
                            return;
                        }
                        if (cmd == 3) {
                            if (RmaVcrControls.this.pauseButton.isSelected()) {
                                RmaVcrControls.this.pauseButton.setSelected(false);
                            }
                            RmaVcrControls.this.slider.setEnabled(true);
                        }
                        if (cmd == 4 || cmd == 5) {
                            RmaVcrControls.this.slider.setEnabled(false);
                        }
                        if (cmd == 8) {
                            RmaVcrControls.this.setCurrentPosition(RmaVcrControls.this.getCurrentPosition() + 1);
                            return;
                        }
                        if (cmd == 7) {
                            RmaVcrControls.this.setCurrentPosition(RmaVcrControls.this.getCurrentPosition() - 1);
                            return;
                        }
                        if (cmd == 9) {
                            RmaVcrControls.this.setCurrentPosition(RmaVcrControls.this.getMaxValue());
                            return;
                        }
                        RmaVcrControls.this.notifyListeners(cmd);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        };
        this.rewindButton.addActionListener(al);
        this.pauseButton.addActionListener(al);
        this.stopButton.addActionListener(al);
        this.playButton.addActionListener(al);
        this.fastForwardButton.addActionListener(al);
        this.skipForwardButton.addActionListener(al);
        this.stepBackButton.addActionListener(al);
        this.stepForwardButton.addActionListener(al);
        this._cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RmaVcrControls.this.notifyListeners(6, RmaVcrControls.this.slider.getValue());
            }
        };
        this.slider.addChangeListener(this._cl);
    }

    private void notifyListeners(int cmd) {
        if ((cmd == 4 || cmd == 5) && this.slider.getValue() == this.slider.getMaximum()) {
            this.slider.setValue(this.slider.getMinimum());
        }
        for (int i = 0; i < this._listenerList.size(); ++i) {
            VCRControlsListener cl = (VCRControlsListener)this._listenerList.elementAt(i);
            cl.controlSelected(cmd);
        }
    }

    private void notifyListeners(int cmd, int value) {
        for (int i = 0; i < this._listenerList.size(); ++i) {
            VCRControlsListener cl = (VCRControlsListener)this._listenerList.elementAt(i);
            cl.sliderMoved(value);
        }
    }

    public void addVCRControlsListener(VCRControlsListener cl) {
        if (cl == null || this._listenerList.contains(cl)) {
            return;
        }
        this._listenerList.addElement(cl);
    }

    public void removeVCRControlsListener(VCRControlsListener cl) {
        if (cl == null) {
            return;
        }
        this._listenerList.removeElement(cl);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, this.getComponents());
    }

    private void setEnabled(boolean enabled, Component[] comps) {
        if (comps == null) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof JPanel) {
                this.setEnabled(enabled, ((JPanel)comps[i]).getComponents());
            }
            comps[i].setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public void showTicMarks(boolean showTics) {
        this._showTicMarks = showTics;
        this.slider.setPaintLabels(this._showTicMarks);
        this.slider.setPaintTicks(this._showTicMarks);
        this.slider.setPaintTrack(this._showTicMarks);
    }

    public void setMinValue(int min) {
        if (VCRDebug.debug) {
            System.out.println("VCRControls.setMinValue to " + min);
        }
        this.slider.removeChangeListener(this._cl);
        this.slider.setMinimum(min);
        this.slider.addChangeListener(this._cl);
    }

    public void setMaxValue(int max) {
        if (VCRDebug.debug) {
            System.out.println("VCRControls.setMaxValue to " + max);
        }
        this.slider.removeChangeListener(this._cl);
        this.slider.setMaximum(max);
        double spacing = (double)max / 10.0;
        if (spacing < 1.0) {
            this.slider.setMajorTickSpacing(1);
        } else if (spacing <= 10.0) {
            this.slider.setMajorTickSpacing((int)spacing);
        } else {
            this.slider.setMajorTickSpacing(10);
        }
        this.slider.addChangeListener(this._cl);
    }

    public int getMaxValue() {
        return this.slider.getMaximum();
    }

    public void setStartLabel(String startText) {
        this.startLabel.setText(startText);
    }

    public void setEndLabel(String endText) {
        this.endLabel.setText(endText);
    }

    public void setCurrentPosition(int pos) {
        if (VCRDebug.debug) {
            System.out.println("VCRControls.setCurrentPosition to " + pos);
        }
        if (this._runner == null) {
            this._runner = new EventRunner();
        }
        this._runner.setCurrentPosition(pos);
        if (pos >= this.slider.getMaximum()) {
            this.slider.setEnabled(true);
        }
    }

    public void setCurrentPosition(int pos, boolean notifyListeners) {
        if (!notifyListeners) {
            this.slider.removeChangeListener(this._cl);
        }
        if (VCRDebug.debug) {
            System.out.println("VCRControls.setCurrentPosition (" + notifyListeners + ") to " + pos);
        }
        this.setCurrentPosition(pos);
        if (!notifyListeners) {
            this.slider.addChangeListener(this._cl);
        }
    }

    public int getCurrentPosition() {
        return this.slider.getValue();
    }

    @Override
    public void controlSelected(int button) {
    }

    @Override
    public void sliderMoved(int pos) {
    }

    public void setNoData(boolean noData) {
        if (noData) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.insets = new Insets(2, 0, 0, 0);
            gbc.anchor = 12;
            gbc.fill = 0;
            gbc.weightx = 1.0;
            this.add((Component)this.noDataLabel, gbc);
        } else {
            this.remove(this.noDataLabel);
        }
    }

    public void setCurrentLocation(String curLoc) {
        if (VCRDebug.debug) {
            System.out.println("VCRControls.setCurrentLocation to " + curLoc);
        }
        this.currentLocation.setText(curLoc);
    }

    public void setSliderEnabled(boolean visible) {
        this.slider.setEnabled(visible);
    }

    public void setSkipToEndEnabled(boolean enabled) {
        this.skipForwardButton.setEnabled(enabled);
    }

    public void setStepBackEnabled(boolean enabled) {
        this.stepBackButton.setEnabled(enabled);
    }

    public class EventRunner
    implements Runnable {
        private int _curPos;

        public void setCurrentPosition(int pos) {
            this._curPos = pos;
            EventQueue.invokeLater(this);
        }

        @Override
        public void run() {
            RmaVcrControls.this.slider.setValue(this._curPos);
        }
    }
}

