/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.client.LookAndFeel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.rmi.Naming;
import java.rmi.Remote;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTextArea;
import rma.swing.RmaJTextField;

public class RmiPortScannerFrame
extends RmaJFrame {
    private RmaJTextField _urlFld;
    private RmaJTextArea _outputFld;
    private JButton _checkBtn;
    private RmaJTextField _statusTxt;
    private RmaJCheckBox _fullInfoCheck;

    public RmiPortScannerFrame() {
        this.buildControls();
        this.addListeners();
        this.pack();
        this.setSize(400, 400);
        this.setLocationRelativeTo(null);
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Check RMI Servers");
        JLabel label = new JLabel("URL:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(10, 5, 0, 5);
        this.getContentPane().add((Component)label, gbc);
        this._urlFld = new RmaJTextField();
        label.setLabelFor(this._urlFld);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(10, 5, 0, 5);
        this.getContentPane().add((Component)this._urlFld, gbc);
        this._checkBtn = new JButton("Check");
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._checkBtn, gbc);
        label = new JLabel("(localhost:1901)");
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0505;
        this.getContentPane().add((Component)label, gbc);
        this._fullInfoCheck = new RmaJCheckBox("Display Full Info");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._fullInfoCheck, gbc);
        this._outputFld = new RmaJTextArea();
        this._outputFld.setTabSize(4);
        this._outputFld.setEditable(false);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)new JScrollPane(this._outputFld), gbc);
        this._statusTxt = new RmaJTextField();
        this._statusTxt.setEditable(false);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._statusTxt, gbc);
    }

    private void addListeners() {
        this._checkBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmiPortScannerFrame.this.checkRmiPortAction();
            }
        });
    }

    protected void checkRmiPortAction() {
        Object url = this._urlFld.getText();
        if (((String)url).length() == 0) {
            this._statusTxt.setText("No URL Entered");
            return;
        }
        if (((String)url).indexOf("/") == -1) {
            url = "//" + (String)url;
        }
        this._statusTxt.setText("");
        this._outputFld.setText("");
        try {
            String[] names = Naming.list((String)url);
            StringBuffer buffer = new StringBuffer();
            if (names != null) {
                for (int ii = 0; ii < names.length; ++ii) {
                    buffer.append(names[ii]);
                    buffer.append("\n");
                }
                if (this._fullInfoCheck.isSelected()) {
                    this.displayFullInfo(buffer, names);
                }
            }
            this._outputFld.setText(buffer.toString());
        }
        catch (Exception e) {
            this._statusTxt.setText(e.getMessage());
            System.out.println(e);
        }
    }

    private void displayFullInfo(StringBuffer buffer, String[] names) {
        for (int ii = 0; ii < names.length; ++ii) {
            try {
                Remote remote = Naming.lookup(names[ii]);
                buffer.append("Info for " + names[ii]);
                buffer.append("\n");
                buffer.append("Class is " + remote.getClass().getName());
                buffer.append("\n");
                Class<?>[] interfaces = remote.getClass().getInterfaces();
                buffer.append("Interfaces implemented are:");
                buffer.append("\n");
                for (int j = 0; j < interfaces.length; ++j) {
                    buffer.append("\t" + interfaces[j].getName());
                    buffer.append("\n");
                    Method[] methods = interfaces[j].getMethods();
                    if (methods == null || methods.length <= 0) continue;
                    buffer.append("\t\tMethods:");
                    buffer.append("\n");
                    for (int m = 0; m < methods.length; ++m) {
                        buffer.append("\t\t" + methods[m].toString());
                        buffer.append("\n");
                    }
                }
                continue;
            }
            catch (Exception e) {
                this._statusTxt.setText("Error retrieving object in registry for " + names[ii] + " Error=" + e);
            }
        }
    }

    public static void main(String[] args) {
        RmiPortScannerFrame frame = new RmiPortScannerFrame();
        LookAndFeel.setLookAndFeel();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

