/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.client.FindTextJDialog;
import hec.io.AsciiSerializableConstants;
import hec.io.Identifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextArea;
import rma.swing.event.ReflectMultiListener;
import rma.util.DBFFileViewer;
import rma.util.RMAIO;

public class SerializerEditDlg
extends RmaJDialog
implements ActionListener,
AsciiSerializableConstants,
UndoableEditListener,
Printable {
    private static HashMap _fields = new HashMap();
    private char[] _txtArray;
    private boolean _canceled = false;
    private boolean _allowsEditing = false;
    private DBFFileViewer _dbfFileViewer;
    private double _record = -1.0;
    private FindTextJDialog _findDialog;
    private JPanel jPanel1;
    private JButton _cmdOk;
    private JButton _cmdCancel;
    private JLabel _descriptionLbl;
    private JTextArea _txtArea;
    private JMenuItem _undoMenuItem;
    private JMenuItem _redoMenuItem;
    private List _edits = new ArrayList();
    private String _printDateStr;
    private StringTokenizer _printTokenizer;
    private HashMap _printCache = new HashMap();
    private ReflectMultiListener _listener;

    public SerializerEditDlg(DBFFileViewer parent, String title, boolean modal, double record) {
        this(parent, title, modal);
        this._dbfFileViewer = parent;
        this._record = record;
        this.allowEditing(true);
    }

    public SerializerEditDlg(Frame parent, String title, boolean modal) {
        this(parent, modal);
        this.setTitle(title);
    }

    public SerializerEditDlg(Dialog parent, String title, boolean modal) {
        this(parent, modal);
        this.setTitle(title);
    }

    public SerializerEditDlg(Frame parent, boolean modal) {
        super(parent, modal);
        this.createControls();
    }

    public SerializerEditDlg(Dialog parent, boolean modal) {
        super(parent, modal);
        this.createControls();
    }

    protected void createControls() {
        this._listener = new ReflectMultiListener();
        this.setTitle("TextEditDlg");
        this.getContentPane().setLayout(new GridBagLayout());
        this.setVisible(false);
        this.setSize(500, 360);
        this.setLocation();
        this._txtArea = new RmaJTextArea(){

            @Override
            public String getToolTipText(MouseEvent e) {
                int length;
                int pos1;
                int pos = this.viewToModel(e.getPoint());
                if (pos <= 0) {
                    return null;
                }
                if (SerializerEditDlg.this._txtArray == null) {
                    SerializerEditDlg.this._txtArray = SerializerEditDlg.this._txtArea.getText().toCharArray();
                }
                if ((pos1 = pos) > (length = SerializerEditDlg.this._txtArray.length) - 1) {
                    return null;
                }
                while (pos1 > 0 && SerializerEditDlg.this._txtArray[pos1--] != '\n') {
                }
                ++pos1;
                int pos2 = pos;
                while (pos2 < SerializerEditDlg.this._txtArray.length && SerializerEditDlg.this._txtArray[pos2++] != '\n') {
                }
                if (pos1 < 0 || pos2 < 0 || pos2 - pos < 0) {
                    return null;
                }
                String line = new String(SerializerEditDlg.this._txtArray, pos1, pos2 - pos1);
                if ((line = line.trim()).indexOf("=") > -1) {
                    String type = RMAIO.getType(line, "=");
                    return (String)_fields.get(type);
                }
                if (line.indexOf("}") > -1) {
                    return (String)_fields.get("}");
                }
                return null;
            }
        };
        this._txtArea.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pos = SerializerEditDlg.this._txtArea.getCaretPosition();
                if (pos < 0) {
                    return;
                }
                String text = SerializerEditDlg.this._txtArea.getText();
                char c2 = text.charAt(pos);
                boolean found = false;
                int cnt = 0;
                int length = text.length();
                if (c2 == '{') {
                    do {
                        if (pos > length - 1) {
                            found = false;
                            break;
                        }
                        if ((c2 = text.charAt(++pos)) == '{') {
                            ++cnt;
                        }
                        if (c2 != '}' || --cnt >= 0) continue;
                        found = true;
                        break;
                    } while (pos < length - 1);
                    if (found) {
                        SerializerEditDlg.this._txtArea.setCaretPosition(pos);
                    }
                } else if (c2 == '}') {
                    do {
                        if (pos < 0) {
                            found = false;
                            break;
                        }
                        if ((c2 = text.charAt(--pos)) == '}') {
                            ++cnt;
                        }
                        if (c2 != '{' || --cnt >= 0) continue;
                        found = true;
                        break;
                    } while (pos >= 0);
                    if (found) {
                        SerializerEditDlg.this._txtArea.setCaretPosition(pos);
                    }
                }
            }
        }, KeyStroke.getKeyStroke(91, 2, true), 0);
        this._txtArea.setToolTipText("Text");
        JScrollPane scrollPane = new JScrollPane(this._txtArea);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        this.getContentPane().add((Component)scrollPane, gbc);
        this.jPanel1 = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.jPanel1, gbc);
        this._cmdOk = new JButton("OK");
        this._cmdOk.setActionCommand("OK");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 0, 5, 0);
        gbc.ipadx = 25;
        this.jPanel1.add((Component)this._cmdOk, gbc);
        this._cmdCancel = new JButton("Cancel");
        this._cmdCancel.setActionCommand("Cancel");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 5, 0);
        this.jPanel1.add((Component)this._cmdCancel, gbc);
        this.createMenus();
        this.registerListeners();
    }

    protected void createMenus() {
        JMenuBar mbar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        mbar.add(menu);
        JMenuItem menuItem = new JMenuItem("Save", 83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "saveAction"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Print", 80);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "printAction"));
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Close", 67);
        menuItem.addActionListener(this._listener.add(this, menuItem, "closeAction"));
        menu.add(menuItem);
        menu = new JMenu("Edit");
        menu.setMnemonic('E');
        mbar.add(menu);
        this._undoMenuItem = new JMenuItem("Undo", 117);
        this._undoMenuItem.setEnabled(false);
        this._undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2, false));
        this._undoMenuItem.addActionListener(this._listener.add(this, this._undoMenuItem, "undoAction"));
        menu.add(this._undoMenuItem);
        this._redoMenuItem = new JMenuItem("Redo", 114);
        this._redoMenuItem.setEnabled(false);
        this._redoMenuItem.addActionListener(this._listener.add(this, this._redoMenuItem, "redoAction"));
        menu.addSeparator();
        menuItem = new JMenuItem("Copy", 67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "copyAction"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Cut", 116);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "cutAction"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Paste", 80);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "pasteAction"));
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Select All", 65);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "selectAllAction"));
        menu.add(menuItem);
        menu = new JMenu("Search");
        menu.setMnemonic('S');
        mbar.add(menu);
        menuItem = new JMenuItem("Find", 70);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "displaySearchDialog"));
        menu.add(menuItem);
        this.setJMenuBar(mbar);
    }

    protected void registerListeners() {
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this._txtArea.getDocument().addUndoableEditListener(this);
        this._cmdOk.addActionListener(this);
        this._cmdCancel.addActionListener(this);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this._txtArea.requestDefaultFocus();
    }

    protected void allowEditing(boolean canEdit) {
        this._allowsEditing = canEdit;
        this._txtArea.setEditable(this._allowsEditing);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation();
        }
        super.setVisible(b);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this._cmdCancel) {
            this.closeAction();
        }
        if (object == this._cmdOk) {
            this.okAction();
        }
    }

    void TextEditDlg_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    public void readIdentifier(Identifier id) {
        if (id != null && id.getFile() != null) {
            try {
                this._txtArea.read(id.getFile().getBufferedReader(), null);
            }
            catch (Exception e) {
                System.out.println("Error reading from Identifier.  " + e);
            }
        }
    }

    @Override
    public void setEditable(boolean tf) {
        this._txtArea.setEditable(tf);
    }

    public void setDescriptionLabel(String label) {
        if (label == null) {
            return;
        }
        this._descriptionLbl.setText(label);
    }

    public void setText(String txt) {
        this._txtArea.setText(txt);
        this._txtArea.setCaretPosition(0);
        this._txtArray = null;
        this._edits.clear();
        this.updateMenu();
    }

    public void appendText(String txt) {
        this._txtArray = null;
    }

    public String getText() {
        return this._txtArea.getText();
    }

    public JTextArea getTextArea() {
        return this._txtArea;
    }

    void closeAction() {
        if (this.isModified() && this._allowsEditing) {
            int opt = JOptionPane.showConfirmDialog(this, "Do you want to save the changes made?", "Save Changes", 1);
            if (opt == 0) {
                this.okAction();
                return;
            }
            if (opt == 2) {
                return;
            }
        }
        this._canceled = true;
        this.dispose();
    }

    void okAction() {
        if (this.isModified() && this._allowsEditing) {
            this.saveAction();
        }
        this._canceled = false;
        this.dispose();
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void setTextDocument(Document d) {
        if (d != null) {
            this._txtArea.setDocument(d);
        }
    }

    public void displaySearchDialog() {
        if (this._findDialog == null) {
            this._findDialog = new FindTextJDialog(this, true);
            this._findDialog.setMatchCase(true);
            this._findDialog.setMatchCaseEnabled(false);
            this._findDialog.setWrapAroundEnabled(false);
            ((JComponent)this.getContentPane()).registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SerializerEditDlg.this._findDialog.getSearchText().length() > 0) {
                        SerializerEditDlg.this.search(SerializerEditDlg.this._findDialog.isMatchCase(), SerializerEditDlg.this._findDialog.getSearchDirection(), SerializerEditDlg.this._findDialog.getSearchText());
                    }
                }
            }, KeyStroke.getKeyStroke(114, 0, true), 1);
        }
        this._findDialog.setVisible(true);
        if (this._findDialog.isCanceled()) {
            return;
        }
        boolean matchCase = this._findDialog.isMatchCase();
        int searchDirection = this._findDialog.getSearchDirection();
        String searchText = this._findDialog.getSearchText();
        this.search(matchCase, searchDirection, searchText);
    }

    public void search(boolean matchCase, int searchDirection, String searchText) {
        int caretPos = this._txtArea.getCaretPosition();
        String text = null;
        try {
            if (searchDirection == 0) {
                text = this._txtArea.getText(0, caretPos - 1);
            } else if (searchDirection == 1) {
                int len = this._txtArea.getText().length();
                len -= caretPos;
                text = this._txtArea.getText(caretPos + 1, --len);
            }
        }
        catch (BadLocationException ble) {
            System.out.println("badLocation " + ble);
            return;
        }
        if (text == null || text.length() < 1) {
            return;
        }
        int pos = searchDirection == 0 ? text.lastIndexOf(searchText) : text.indexOf(searchText);
        if (pos > -1) {
            if (searchDirection == 1) {
                pos += caretPos + 1;
            }
            this._txtArea.setCaretPosition(pos);
            this._txtArea.setSelectionStart(pos);
            this._txtArea.setSelectionEnd(pos + searchText.length());
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent ev) {
        UndoableEdit lastEdit = ev.getEdit();
        if (lastEdit.canUndo()) {
            this._edits.add(lastEdit);
        }
        this.updateMenu();
    }

    protected void updateMenu() {
        UndoableEdit lastEdit = this.getLastEdit();
        if (lastEdit != null) {
            this._undoMenuItem.setEnabled(lastEdit.canUndo());
            this._redoMenuItem.setEnabled(lastEdit.canRedo());
            this._undoMenuItem.setToolTipText(lastEdit.getUndoPresentationName());
            this._redoMenuItem.setToolTipText(lastEdit.getRedoPresentationName());
        } else {
            this._undoMenuItem.setEnabled(false);
            this._redoMenuItem.setEnabled(false);
            this._undoMenuItem.setToolTipText(null);
            this._redoMenuItem.setToolTipText(null);
        }
    }

    protected UndoableEdit popLastEdit() {
        if (this._edits.size() == 0) {
            return null;
        }
        return (UndoableEdit)this._edits.remove(this._edits.size() - 1);
    }

    protected UndoableEdit getLastEdit() {
        if (this._edits.size() == 0) {
            return null;
        }
        return (UndoableEdit)this._edits.get(this._edits.size() - 1);
    }

    public void printAction() {
        try {
            PrinterJob prnJob = PrinterJob.getPrinterJob();
            prnJob.setPrintable(this);
            if (!prnJob.printDialog()) {
                return;
            }
            this._printDateStr = null;
            this._printCache.clear();
            this._printTokenizer = new StringTokenizer(this._txtArea.getText(), "\n");
            prnJob.print();
        }
        catch (PrinterException e) {
            e.printStackTrace();
            System.err.println("Printing error: " + e.toString());
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        String fileName = this.getTitle();
        if (this._printDateStr == null) {
            this._printDateStr = new Date().toString().substring(4);
        }
        if (!this._printTokenizer.hasMoreTokens()) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        g2.setFont(new Font("Helvetica", 0, 10));
        int fontHeight = g2.getFontMetrics().getHeight();
        int fontDesent = g2.getFontMetrics().getDescent();
        double imageableX = pageFormat.getImageableX();
        double imageableY = pageFormat.getImageableY();
        double pageHeight = pageFormat.getImageableHeight() - (double)fontHeight;
        double pageWidth = pageFormat.getImageableWidth();
        double areaWidth = this._txtArea.getWidth();
        double scale = 1.0;
        if (areaWidth >= pageWidth) {
            scale = pageWidth / areaWidth;
        }
        int linesOnPage = (int)(pageHeight / (double)(fontHeight + fontDesent));
        linesOnPage -= 2;
        int x = (int)pageFormat.getImageableX() + 10;
        int y = (int)pageFormat.getImageableY() + 12;
        g.drawString("File: " + fileName + ", Page: " + (pageIndex + 1), x, y);
        y += 36;
        pageHeight = pageFormat.getImageableY() + pageFormat.getImageableHeight();
        ArrayList<String> printCacheData = (ArrayList<String>)this._printCache.get(new Integer(pageIndex));
        if (printCacheData == null) {
            printCacheData = new ArrayList<String>();
            this._printCache.put(new Integer(pageIndex), printCacheData);
            while ((double)(y + 12) < pageHeight && this._printTokenizer.hasMoreTokens()) {
                String str = this._printTokenizer.nextToken();
                printCacheData.add(str);
                g.drawString(str, x, y);
                y += 12;
            }
        } else {
            for (int i = 0; i < printCacheData.size(); ++i) {
                g.drawString((String)printCacheData.get(i), x, y);
                y += 12;
            }
        }
        return 0;
    }

    public void undoAction() {
        UndoableEdit lastEdit = this.popLastEdit();
        if (lastEdit == null) {
            return;
        }
        lastEdit.undo();
        if (lastEdit.canUndo()) {
            this._edits.add(lastEdit);
        }
        this.updateMenu();
    }

    public void cutAction() {
        this._txtArea.cut();
    }

    public void copyAction() {
        this._txtArea.copy();
    }

    public void pasteAction() {
        this._txtArea.paste();
    }

    public void selectAllAction() {
        this._txtArea.selectAll();
    }

    public void saveAction() {
        if (this._dbfFileViewer != null) {
            this._dbfFileViewer.saveRecord(this._record, this._txtArea.getText());
        }
    }

    static {
        _fields.put("B", "Byte");
        _fields.put("S", "Short");
        _fields.put("I", "Integer");
        _fields.put("J", "Long");
        _fields.put("F", "Float");
        _fields.put("D", "Double");
        _fields.put("V", "Void");
        _fields.put("L", "Class");
        _fields.put("STR", "String");
        _fields.put("FLD", "Field");
        _fields.put("{", "Begin Object");
        _fields.put("}", "End Object");
        _fields.put("ID", "System Generated Object ID");
        _fields.put("REF", "Reference to Object ID");
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == SerializerEditDlg.this) {
                SerializerEditDlg.this.TextEditDlg_WindowClosing(event);
            }
        }
    }
}

