/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;
import rma.swing.RmaInsets;
import rma.util.RMAIO;

public class SplashWindow
extends JWindow {
    public static final String STANDARD_HEC_INFO = "\n<br><br>For more information contact:\n<br><FONT SIZE=4>Hydrologic Engineering Center</FONT>\nInstitute for Water Resources\nUS Army Corps of Engineers\n609 Second Street\nDavis, CA 95616";
    public static final String HEC_URL = "www.hec.usace.army.mil";
    private String _urlText;
    private JLabel _urlLabel;

    public SplashWindow(String text, String url, Frame f, int waitTime, String image) {
        super(f);
        if (image == null) {
            image = "Images/heclogo2.gif";
        }
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        LineBorder border = new LineBorder(UIManager.getColor("TextField.foreground"), 3);
        BevelBorder border2 = new BevelBorder(0);
        panel.setBorder(BorderFactory.createCompoundBorder(border2, border));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(0, 0, 0, 0);
        this.getContentPane().add((Component)panel, gbc);
        JLabel l = new JLabel(new ImageIcon(image));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)l, gbc);
        l = new JLabel(new ImageIcon("Images/hecanimlog_bottom.gif"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(0, 5, 0, 5);
        StringTokenizer strTok = new StringTokenizer(text, "\n", true);
        StringBuffer buffer = new StringBuffer(text.length() + 20);
        buffer.append("<html><FONT FACE=\"Arial\">");
        buffer.append("<FONT SIZE=18>");
        buffer.append(strTok.nextToken());
        buffer.append("</FONT><br>");
        strTok.nextToken();
        int cnt = strTok.countTokens();
        boolean lastWasVersion = false;
        while (strTok.hasMoreTokens()) {
            String s = strTok.nextToken();
            if (s.equals("\n")) {
                buffer.append("<br>");
                continue;
            }
            if (s.startsWith("Version")) {
                buffer.append("<FONT SIZE=6>");
                buffer.append(s);
                buffer.append("</FONT>");
                lastWasVersion = true;
                continue;
            }
            if (lastWasVersion) {
                lastWasVersion = false;
                buffer.append("<FONT SIZE=6>");
                buffer.append(s);
                buffer.append("</FONT>");
                continue;
            }
            buffer.append(s);
        }
        String buf = buffer.toString();
        JLabel aboutLabel = new JLabel(buf);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)aboutLabel, gbc);
        if (url != null) {
            this._urlText = url;
            this._urlLabel = new JLabel("<html>" + url + "</html>");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridheight = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(5, 5, 0, 5);
            panel.add((Component)this._urlLabel, gbc);
        }
        aboutLabel.setBackground(this.getContentPane().getBackground());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(400, 300);
        Dimension labelSize = this.getSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        if (this._urlLabel != null && RMAIO.getOSType() == 0) {
            this._urlLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    String[] cmd = new String[]{"cmd.exe", "/c", "start", SplashWindow.this._urlText};
                    try {
                        Runtime.getRuntime().exec(cmd);
                    }
                    catch (IOException ioe) {
                        System.out.println("Exception running " + cmd + " " + e);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    SplashWindow.this._urlLabel.setText("<html><font=+0 color=blue><u>" + SplashWindow.this._urlText + "</u></font></html>");
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SplashWindow.this._urlLabel.setText("<html>" + SplashWindow.this._urlText + "</html>");
                }
            });
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SplashWindow.this.setVisible(false);
                SplashWindow.this.dispose();
            }
        });
        final int pause = waitTime;
        final Runnable closerRunner = new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.setVisible(false);
                SplashWindow.this.dispose();
            }
        };
        Runnable waitRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(pause);
                    SwingUtilities.invokeAndWait(closerRunner);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SplashWindow.this.toFront();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SplashWindow.this.toFront();
                        SplashWindow.this.repaint();
                    }
                });
            }
        });
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.requestFocus();
            }
        });
        Thread splashThread = new Thread(waitRunner, "SplashThread");
        splashThread.setDaemon(true);
        splashThread.start();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public static void main(String[] args) {
        new SplashWindow("ResSim\nVersion 1.0\n<br><br>For more information contact:\n<br><FONT SIZE=4>Hydrologic Engineering Center</FONT>\nInstitute for Water Resources\nUS Army Corps of Engineers\n609 Second Street\nDavis, CA 95616", HEC_URL, new Frame(), 15000, "Images/rss/dam256contrastbrighter.gif");
    }
}

