/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.io.Identifier;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import rma.swing.RmaInsets;
import rma.swing.RmaJFrame;
import rma.swing.TextEditPanel;

public class TextEditFrame
extends RmaJFrame {
    private TextEditPanel _editPanel;
    private boolean _canceled = false;

    public TextEditFrame(String title, Identifier id) {
        this(title);
        this.readIdentifier(id);
    }

    public TextEditFrame(String title) {
        super(title);
        this.createControls(title);
    }

    public TextEditFrame() {
        this.createControls(null);
    }

    protected void createControls(String title) {
        if (title != null) {
            this.setTitle(title);
        }
        this.getContentPane().setLayout(new GridBagLayout());
        this.setVisible(false);
        this.setSize(500, 360);
        this.setLocation();
        this._editPanel = new TextEditPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this._editPanel, gbc);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.pack();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation();
        }
        super.setVisible(b);
    }

    void TextEditDlg_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    public void readIdentifier(Identifier id) {
        this._editPanel.readIdentifier(id);
    }

    @Override
    public void setEditable(boolean tf) {
        this._editPanel.setEditable(tf);
    }

    public void setDescriptionLabel(String label) {
        this._editPanel.setDescriptionLabel(label);
    }

    public void setText(String txt) {
        this._editPanel.setText(txt);
    }

    public void appendText(String txt) {
        this._editPanel.appendText(txt);
    }

    public String getText() {
        return this._editPanel.getText();
    }

    public JTextArea getTextArea() {
        return this._editPanel.getTextArea();
    }

    void CmdCancel_Action() {
        this._canceled = true;
        this.dispose();
    }

    void CmdOk_Action() {
        this._canceled = false;
        this.dispose();
    }

    public boolean isCanceled() {
        return this._editPanel.isCanceled();
    }

    public void setTextDocument(Document d) {
        this._editPanel.setTextDocument(d);
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == TextEditFrame.this) {
                TextEditFrame.this.TextEditDlg_WindowClosing(event);
            }
        }
    }
}

