/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.io.Identifier;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJTextArea;

public class TextEditPanel
extends JPanel {
    private boolean _canceled = false;
    private boolean _scrollOnAppend = false;
    JPanel jPanel1;
    ButtonCmdPanel _cmdPanel;
    JLabel _descriptionLbl;
    RmaJTextArea _txtArea;
    JScrollPane _textAreaScrollPane;
    DocumentListener _documentListener;

    public TextEditPanel(Identifier id) {
        this();
        this.readIdentifier(id);
    }

    public TextEditPanel() {
        super(new GridBagLayout());
        this.createControls();
    }

    protected void createControls() {
        this._descriptionLbl = new JLabel("");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        gbc.ipadx = 300;
        this.add((Component)this._descriptionLbl, gbc);
        this._txtArea = new RmaJTextArea(30, 80);
        this._txtArea.setWrapStyleWord(true);
        this._txtArea.setLineWrap(true);
        this._txtArea.setDragEnabled(true);
        this._textAreaScrollPane = new JScrollPane(this._txtArea);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        this.add((Component)this._textAreaScrollPane, gbc);
        this.addCmdPanel(12);
        this._txtArea.requestDefaultFocus();
    }

    protected void addCmdPanel(int buttonOpts) {
        if (this._cmdPanel != null) {
            this.remove(this._cmdPanel);
            this._cmdPanel = null;
        }
        this._cmdPanel = new ButtonCmdPanel(buttonOpts);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.add((Component)this._cmdPanel, gbc);
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                Window w = SwingUtilities.windowForComponent(TextEditPanel.this);
                switch (e.getID()) {
                    case 8: {
                        TextEditPanel.this._canceled = false;
                        w.setVisible(false);
                        break;
                    }
                    case 4: 
                    case 256: {
                        TextEditPanel.this._canceled = true;
                        w.setVisible(false);
                    }
                }
            }
        });
    }

    public void readIdentifier(Identifier id) {
        if (id != null && id.getFile() != null) {
            try {
                this._txtArea.read(id.getFile().getBufferedReader(), null);
            }
            catch (Exception e) {
                System.out.println("Error reading from Identifier.  " + e);
            }
        }
    }

    public void setEditable(boolean tf) {
        this._txtArea.setEditable(tf);
        if (!tf) {
            this.addCmdPanel(256);
        }
    }

    public void setDescriptionLabel(String label) {
        if (label == null) {
            return;
        }
        this._descriptionLbl.setText(label);
    }

    public void setText(String txt) {
        this._txtArea.setText(txt);
        this._txtArea.setCaretPosition(0);
    }

    public void setToolTipTextDisabled(boolean tf) {
        this._txtArea.setToolTipTextDisabled(tf);
    }

    public boolean getToolTipTextDisabled() {
        return this._txtArea.getToolTipTextDisabled();
    }

    public boolean getScrollOnAppend() {
        return this._scrollOnAppend;
    }

    public void setScrollOnAppend(boolean scrollOnAppend) {
        if (scrollOnAppend && this._documentListener == null) {
            this._documentListener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    TextEditPanel.this.updateVerticalScrollBar();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    TextEditPanel.this.updateVerticalScrollBar();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    TextEditPanel.this.updateVerticalScrollBar();
                }
            };
            this._txtArea.getDocument().addDocumentListener(this._documentListener);
        } else if (!scrollOnAppend) {
            this._txtArea.getDocument().removeDocumentListener(this._documentListener);
            this._documentListener = null;
        }
        this._scrollOnAppend = scrollOnAppend;
    }

    private void updateVerticalScrollBar() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                JScrollBar vertScrollBar = TextEditPanel.this._textAreaScrollPane.getVerticalScrollBar();
                vertScrollBar.setValue(vertScrollBar.getMaximum());
                vertScrollBar.repaint();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void appendText(String txt) {
        this._txtArea.append(txt);
    }

    public String getText() {
        return this._txtArea.getText();
    }

    public JTextArea getTextArea() {
        return this._txtArea;
    }

    void CmdCancel_Action() {
        this._canceled = true;
    }

    void CmdOk_Action() {
        this._canceled = false;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void setTextDocument(Document d) {
        if (d != null) {
            this._txtArea.setDocument(d);
        }
    }
}

