/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.client.FindTextJDialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class TextSearcher {
    protected int _searchDirection;
    protected String _searchText = "";
    protected FindTextJDialog _findDialog = null;
    protected boolean _matchCase;
    protected boolean _wrapAround;
    private JTextComponent _textFld;

    public TextSearcher(JTextComponent textFld) {
        this._textFld = textFld;
    }

    public void displayFindDialog() {
        if (this._findDialog == null) {
            Window w = SwingUtilities.windowForComponent(this._textFld);
            this._findDialog = w instanceof JDialog ? new FindTextJDialog((JDialog)w, true) : new FindTextJDialog((Frame)((JFrame)w), true);
            this._findDialog.setMatchCase(true);
            this._findDialog.setMatchCaseEnabled(true);
            this._findDialog.setWrapAroundEnabled(true);
        }
        this._findDialog.setVisible(true);
        if (this._findDialog.isCanceled()) {
            return;
        }
        this._matchCase = this._findDialog.isMatchCase();
        this._wrapAround = this._findDialog.isWrapAround();
        this._searchDirection = this._findDialog.getSearchDirection();
        this._searchText = this._findDialog.getSearchText();
        this.search();
    }

    public void searchNext() {
        this.search(true);
    }

    public void searchPrevious() {
        this.search(false);
    }

    public void search() {
        this.search(this._searchDirection == 1);
    }

    public void search(boolean searchNext) {
        if (this._findDialog == null) {
            this.displayFindDialog();
            return;
        }
        if (this._searchText == null || this._searchText.length() == 0) {
            System.out.println("no Search text specified");
            return;
        }
        int loc = this._textFld.getCaretPosition();
        if (loc < 0) {
            loc = 0;
        }
        String text = this.getText();
        if (searchNext) {
            loc = this._matchCase ? text.indexOf(this._searchText, loc) : text.toLowerCase().indexOf(this._searchText.toLowerCase(), loc);
            if (loc < 0 && this._wrapAround) {
                loc = this._matchCase ? text.indexOf(this._searchText) : text.toLowerCase().indexOf(this._searchText.toLowerCase());
            }
        } else {
            loc = this._textFld.getSelectedText() == null ? --loc : this._textFld.getSelectionStart() - 1;
            if (loc >= 0) {
                loc = this._matchCase ? text.lastIndexOf(this._searchText, loc) : text.toLowerCase().lastIndexOf(this._searchText.toLowerCase(), loc);
            }
            if (loc < 0 && this._wrapAround) {
                loc = this._matchCase ? text.lastIndexOf(this._searchText) : text.toLowerCase().lastIndexOf(this._searchText.toLowerCase());
            }
        }
        if (loc < 0) {
            Window w = SwingUtilities.windowForComponent(this._textFld);
            JOptionPane.showMessageDialog(w, "<html>String <b>" + this._searchText + "</b> not found</html>", "Search Failed", 1);
        } else {
            try {
                this._textFld.setCaretPosition(loc);
                this._textFld.select(loc, loc + this._searchText.length());
                if (searchNext) {
                    this._textFld.scrollRectToVisible(this._textFld.modelToView(loc + this._searchText.length()));
                } else {
                    this._textFld.scrollRectToVisible(this._textFld.modelToView(loc));
                }
            }
            catch (BadLocationException be) {
                System.out.println(be);
            }
        }
    }

    private String getText() {
        if (this._textFld instanceof JEditorPane) {
            Document doc = this._textFld.getDocument();
            int length = doc.getLength();
            try {
                return doc.getText(0, length - 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return this._textFld.getText();
    }
}

