/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import rma.swing.RmaInsets;

public class ToolTipWindow
extends JWindow {
    private JComponent _parentComponent;

    public ToolTipWindow(JComponent parentComponent, String ttText) {
        super(SwingUtilities.windowForComponent(parentComponent));
        this._parentComponent = parentComponent;
        this.buildControls(ttText);
        this.addListeners();
        this.setSizeAndLocation();
        this.setVisible(true);
    }

    private void buildControls(String ttText) {
        Color background = UIManager.getColor("ToolTip.background");
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel label = new JLabel(ttText);
        label.setBackground(background);
        label.setOpaque(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        JSeparator sep = new JSeparator(0);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)sep, gbc);
        label = new JLabel("(Press escape to close)");
        label.setBackground(background);
        label.setOpaque(true);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 14;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this.getContentPane().setBackground(background);
        ((JComponent)this.getContentPane()).setOpaque(true);
        this.getRootPane().setBorder(BorderFactory.createEtchedBorder());
    }

    private void addListeners() {
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolTipWindow.this.setVisible(false);
            }
        };
        this.getRootPane().getInputMap().put(KeyStroke.getKeyStroke(27, 0), "closeWindow");
        this.getRootPane().getActionMap().put("closeWindow", closeAction);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ToolTipWindow.this.setVisible(false);
            }
        });
    }

    private void setSizeAndLocation() {
        this.pack();
        Point p = this._parentComponent.getLocationOnScreen();
        Dimension d = this.getSize();
        int y = p.y - d.height;
        this.setLocationRelativeTo(this._parentComponent);
        p = this.getLocation();
        p.y = y;
        this.setLocation(p);
    }
}

