/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import rma.swing.MDIDesktopPane;

public class WindowMenu
extends JMenu {
    private MDIDesktopPane desktop;
    private JMenuItem cascade;
    private JMenuItem close;
    private JMenuItem closeAll;

    public WindowMenu(MDIDesktopPane desktop) {
        this.desktop = desktop;
        this.cascade = new JMenuItem("Cascade");
        this.close = new JMenuItem("Close");
        this.close.setMnemonic('C');
        this.closeAll = new JMenuItem("Close All");
        this.setText("Window");
        this.cascade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.desktop.cascade();
            }
        });
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.desktop.removeSelectedWindow();
            }
        });
        this.closeAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.desktop.removeAll();
            }
        });
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                WindowMenu.this.removeAll();
            }

            @Override
            public void menuSelected(MenuEvent e) {
                WindowMenu.this.buildChildMenus();
            }
        });
    }

    private void buildChildMenus() {
        JInternalFrame[] array = this.desktop.getAllFrames();
        this.add(this.cascade);
        this.addSeparator();
        this.add(this.close);
        this.add(this.closeAll);
        if (array.length > 0) {
            this.addSeparator();
        }
        this.cascade.setEnabled(array.length > 0);
        this.close.setEnabled(array.length > 0);
        this.closeAll.setEnabled(array.length > 0);
        for (int i = 0; i < array.length; ++i) {
            ChildMenuItem menu = new ChildMenuItem(array[i]);
            menu.setState(i == 0);
            menu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JInternalFrame frame = ((ChildMenuItem)ae.getSource()).getFrame();
                    frame.moveToFront();
                    try {
                        frame.setSelected(true);
                    }
                    catch (PropertyVetoException e) {
                        e.printStackTrace();
                    }
                }
            });
            menu.setIcon(array[i].getFrameIcon());
            this.add(menu);
        }
    }

    class ChildMenuItem
    extends JCheckBoxMenuItem {
        private JInternalFrame frame;

        public ChildMenuItem(JInternalFrame frame) {
            super(frame.getTitle());
            this.frame = frame;
        }

        public JInternalFrame getFrame() {
            return this.frame;
        }
    }
}

