/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class WindowUtilities {
    private static WindowListener _windowListener = new WindowAdapter(){

        @Override
        public void windowOpened(final WindowEvent e) {
            Runnable r = new Runnable(){
                int cnt = 0;

                @Override
                public void run() {
                    ++this.cnt;
                    e.getWindow().setAlwaysOnTop(true);
                    e.getWindow().toFront();
                    e.getWindow().requestFocus();
                    e.getWindow().setAlwaysOnTop(false);
                    if (!e.getWindow().isActive() && this.cnt < 3) {
                        EventQueue.invokeLater(this);
                    }
                    e.getWindow().removeWindowListener(_windowListener);
                }
            };
            EventQueue.invokeLater(r);
        }
    };

    public static void toFront(final Window w) {
        if (w.isVisible()) {
            Runnable r = new Runnable(){
                int cnt = 0;

                @Override
                public void run() {
                    ++this.cnt;
                    w.setAlwaysOnTop(true);
                    w.toFront();
                    w.requestFocus();
                    w.setAlwaysOnTop(false);
                    if (!w.isActive() && this.cnt < 3) {
                        EventQueue.invokeLater(this);
                    }
                }
            };
            EventQueue.invokeLater(r);
            return;
        }
        w.addWindowListener(_windowListener);
    }

    public static boolean setLocation(Window window, int x, int y) {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (!devices[i].getDefaultConfiguration().getBounds().contains(x, y)) continue;
            window.setLocation(x, y);
            return true;
        }
        return false;
    }

    public static Window getSelectedWindow() {
        return WindowUtilities.getSelectedWindow(Window.getWindows());
    }

    public static Window getSelectedWindow(Window[] windows) {
        Window result = null;
        for (int i = 0; i < windows.length; ++i) {
            Window window = windows[i];
            if (window.isActive() || window.isFocused()) {
                result = window;
                break;
            }
            Window[] ownedWindows = window.getOwnedWindows();
            if (ownedWindows != null && ownedWindows.length > 0 && (result = WindowUtilities.getSelectedWindow(ownedWindows)) != null) break;
        }
        return result;
    }
}

