/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.action;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import rma.swing.RmaImage;
import rma.swing.action.ActionGroup;

public class ActionButton
extends JComponent
implements PropertyChangeListener {
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int FLAT = 2;
    private static boolean GLOBAL_MOUSE_DOWN = false;
    private static boolean GLOBAL_MENU_PRESSED = false;
    private Color m_shadow = null;
    private Color m_highlite = null;
    private int m_menuButtonWidth = 20;
    private boolean m_rollover = false;
    private String m_text = null;
    private boolean m_toggleEnabled = false;
    private boolean m_pressed = false;
    private boolean m_popupPressed = false;
    private boolean m_showText = false;
    private int m_spacer = 2;
    private int m_border = 2;
    private Icon m_icon = null;
    private Icon m_disIcon = null;
    private Icon m_menuIcon = null;
    private Action m_action = null;
    private int m_menuWidth = 12;
    private int m_permanentState = -1;
    private Action m_ButtonAction;
    private Insets m_insets;
    Rectangle m_bRect = new Rectangle();
    Rectangle m_mRect = new Rectangle();

    public ActionButton() {
        this.m_shadow = UIManager.getColor("Separator.shadow");
        this.m_highlite = UIManager.getColor("Separator.highlight");
        this.enableEvents(16L);
    }

    public ActionButton(Action action) {
        this();
        this.setAction(action);
    }

    public void setShowText(boolean b) {
        this.m_showText = b;
    }

    public void setPermanentState(int state) {
        if (state != 1 && state != 0 && state != 2) {
            return;
        }
        this.m_permanentState = state;
    }

    public void unsetPermanentState() {
        this.m_permanentState = -1;
    }

    public void setIcon(Icon i) {
        this.m_icon = i;
        this.m_disIcon = i == null ? null : RmaImage.getDisabledIcon(i);
    }

    public int getButtonState() {
        boolean enabled = this.isEnabled();
        if (this.m_permanentState != -1 && !this.m_pressed) {
            return this.m_permanentState;
        }
        if (this.m_rollover && this.m_pressed && enabled && !this.m_popupPressed) {
            return 1;
        }
        if (this.m_rollover && this.m_pressed && enabled) {
            return 1;
        }
        if (this.m_rollover && enabled) {
            return 0;
        }
        return 2;
    }

    public int getPopupButtonState() {
        if (this.m_action instanceof ActionGroup) {
            if (this.m_permanentState != -1 && !this.m_popupPressed) {
                return this.m_permanentState;
            }
            boolean enabled = this.isEnabled();
            if (this.m_popupPressed) {
                return 1;
            }
            if (this.m_rollover && this.m_pressed && enabled) {
                return 1;
            }
            if (this.m_rollover && enabled) {
                return 0;
            }
        }
        return 2;
    }

    @Override
    public void paintComponent(Graphics g) {
        FontMetrics fontmetrics;
        Dimension d = this.getSize();
        int menuWidth = 0;
        if (this.hasPopupMenu()) {
            this.m_bRect.setRect(0.0, 0.0, d.width - this.m_menuWidth, d.height);
            this.m_mRect.setRect(d.width - this.m_menuWidth, 0.0, this.m_menuWidth, d.height);
            menuWidth = this.m_menuWidth;
        } else {
            this.m_bRect.setRect(0.0, 0.0, d.width, d.height);
        }
        this.paintBorder(g);
        int state = this.getButtonState();
        if (state != 2) {
            this.paintBorder(g, this.m_bRect, state != 0);
        }
        if (this.hasPopupMenu()) {
            int pState = this.getPopupButtonState();
            if (pState != 2) {
                this.paintBorder(g, this.m_mRect, pState != 0);
            }
            Color tempColor = g.getColor();
            g.setColor(this.isEnabled() ? Color.black : this.m_shadow);
            int x = this.m_mRect.x + (int)Math.ceil((this.m_menuWidth - 5) / 2);
            int y = this.m_mRect.y + (int)Math.ceil((this.m_mRect.height - 3) / 2);
            if (this.getPopupButtonState() == 1) {
                ++x;
                ++y;
            }
            g.drawLine(x, y, x + 4, y);
            g.drawLine(x + 1, y + 1, x + 3, y + 1);
            g.drawLine(x + 2, y + 2, x + 2, y + 2);
            g.setColor(tempColor);
        }
        Icon icon = this.getIcon();
        int iconx = 0;
        int icony = 0;
        if (icon != null) {
            if (this.m_showText && this.m_text != null) {
                Font font = this.getFont();
                if (font == null) {
                    font = UIManager.getFont("Label.font");
                }
                fontmetrics = g.getFontMetrics(font);
                int textWidth = fontmetrics.stringWidth(this.m_text);
                iconx = (d.width - menuWidth) / 2 - icon.getIconWidth() / 2;
                icony = (d.height - icon.getIconHeight() - this.m_spacer - fontmetrics.getHeight()) / 2;
            } else {
                iconx = (d.width - menuWidth) / 2 - icon.getIconWidth() / 2;
                icony = d.height / 2 - icon.getIconHeight() / 2;
                if (state == 1) {
                    ++iconx;
                    ++icony;
                }
            }
            icon.paintIcon(this, g, iconx, icony);
        }
        if (this.m_showText && this.m_text != null) {
            Font font = UIManager.getFont("Label.font");
            fontmetrics = g.getFontMetrics(font);
            int textx = 0;
            int texty = 0;
            int iconheight = 0;
            if (icon != null) {
                iconheight += icon.getIconHeight() / 2 + this.m_spacer;
            }
            if ((textx = (int)Math.ceil((d.width - menuWidth - fontmetrics.stringWidth(this.m_text)) / 2)) < 0) {
                textx = 0;
            }
            if ((texty = iconheight + (int)Math.ceil((d.height - fontmetrics.getHeight()) / 2) + fontmetrics.getAscent()) < 0) {
                texty = 0;
            }
            Color forground = this.getForeground();
            if (this.isEnabled()) {
                g.setColor(UIManager.getColor("Label.foreground"));
            } else {
                g.setColor(this.m_shadow);
            }
            g.drawString(this.m_text, textx, texty);
            g.setColor(forground);
        }
    }

    public Icon getIcon() {
        if (this.isEnabled()) {
            return this.m_icon;
        }
        return this.m_disIcon;
    }

    public void paintBorder(Graphics g, Rectangle rect, boolean invert) {
        Color topLeft;
        Color bottomRight;
        if (invert) {
            bottomRight = this.m_highlite;
            topLeft = this.m_shadow;
        } else {
            bottomRight = this.m_shadow;
            topLeft = this.m_highlite;
        }
        g.setColor(topLeft);
        g.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
        g.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
        g.setColor(bottomRight);
        g.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1);
        g.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
    }

    public boolean hasPopupMenu() {
        return this.m_action instanceof ActionGroup;
    }

    @Override
    public Dimension getPreferredSize() {
        int width = 0;
        int height = 0;
        if (this.m_icon != null) {
            width = this.m_icon.getIconWidth() + 6 + 6;
            height = this.m_icon.getIconHeight() + 6 + 6;
        }
        if (this.m_action instanceof ActionGroup) {
            width += this.m_menuWidth;
        }
        if (this.m_text != null && this.m_showText) {
            Graphics g = this.getGraphics();
            Font font = this.getFont();
            if (font == null) {
                font = UIManager.getFont("Label.font");
            }
            FontMetrics fontmetrics = g.getFontMetrics(font);
            width += fontmetrics.stringWidth(this.m_text);
            height += fontmetrics.getHeight();
            if (this.m_icon != null) {
                height += this.m_spacer;
            }
            if (this.m_icon == null) {
                Insets i = this.getInsets();
                Border border = this.getBorder();
                if (border != null) {
                    Insets bi = border.getBorderInsets(this);
                    width += bi.left + bi.right;
                    height += bi.top + bi.bottom;
                }
                width += i.left + i.right;
                height += i.top + i.bottom;
            }
        }
        return new Dimension(width, height);
    }

    @Override
    public int getHeight() {
        return this.getPreferredSize().height;
    }

    @Override
    public int getWidth() {
        return this.getPreferredSize().width;
    }

    @Override
    protected void processMouseEvent(MouseEvent event) {
        if (SwingUtilities.isRightMouseButton(event)) {
            return;
        }
        super.processMouseEvent(event);
        switch (event.getID()) {
            case 504: {
                this.m_rollover = true;
                if (!this.m_pressed && GLOBAL_MOUSE_DOWN || GLOBAL_MENU_PRESSED) {
                    return;
                }
                this.repaint();
                break;
            }
            case 505: {
                this.m_rollover = false;
                if (this.m_popupPressed) {
                    return;
                }
                this.m_rollover = false;
                this.repaint();
                break;
            }
            case 501: {
                this.m_rollover = true;
                if (GLOBAL_MOUSE_DOWN || GLOBAL_MENU_PRESSED) {
                    return;
                }
                if (!this.isEnabled()) break;
                GLOBAL_MOUSE_DOWN = true;
                if (this.hasPopupMenu() && event.getX() > this.getSize().width - this.m_menuWidth) {
                    this.m_popupPressed = true;
                    GLOBAL_MENU_PRESSED = true;
                    this.repaint();
                    JPopupMenu menu = new JPopupMenu();
                    ActionGroup group = (ActionGroup)this.m_action;
                    this.buildMenu(menu, group);
                    menu.addPopupMenuListener(new ActionPMenuListener());
                    menu.show(this, 0, this.getSize().height);
                    return;
                }
                this.m_pressed = true;
                this.repaint();
                break;
            }
            case 502: {
                if (!this.isEnabled()) break;
                if (this.m_pressed && !this.m_popupPressed && this.m_ButtonAction != null && this.m_ButtonAction.isEnabled()) {
                    this.m_ButtonAction.actionPerformed(new ActionEvent(this, 1001, (String)this.m_ButtonAction.getValue("ActionCommandKey"), event.getModifiers()));
                }
                this.m_pressed = false;
                GLOBAL_MOUSE_DOWN = false;
                if (this.m_rollover && !this.m_popupPressed) {
                    this.fireEvent();
                }
                this.repaint();
            }
        }
    }

    private void buildMenu(JComponent menu, ActionGroup group) {
        for (int z = 0; z < group.getActionCount(); ++z) {
            Action action = group.getAction(z);
            if (action instanceof ActionGroup) {
                JMenu submenu = new JMenu((String)action.getValue("Name"));
                menu.add(submenu);
                this.buildMenu(submenu, (ActionGroup)action);
                continue;
            }
            if (menu instanceof JPopupMenu) {
                ((JPopupMenu)menu).add(action);
                continue;
            }
            if (!(menu instanceof JMenu)) continue;
            ((JMenu)menu).add(action);
        }
    }

    private void fireEvent() {
        if (this.m_action == null) {
            return;
        }
        if (!this.m_action.isEnabled()) {
            return;
        }
        ActionEvent ae = new ActionEvent(this, 10, "COMMAND");
        this.m_action.actionPerformed(ae);
    }

    @Override
    public Insets insets() {
        if (this.m_insets == null) {
            return super.insets();
        }
        return this.m_insets;
    }

    public void setInsets(Insets insets) {
        this.m_insets = insets;
    }

    public void setButtonAction(Action action) {
        this.m_ButtonAction = action;
    }

    public void setAction(Action action) {
        if (this.m_action != null) {
            this.m_action.removePropertyChangeListener(this);
        }
        this.m_action = action;
        action.addPropertyChangeListener(this);
        this.m_icon = (Icon)action.getValue("SmallIcon");
        this.m_text = (String)action.getValue("Name");
        if (this.m_text != null) {
            this.m_showText = true;
        }
        this.setEnabled(this.m_action.isEnabled());
        Object toolTip = action.getValue("ShortDescription");
        if (toolTip instanceof String) {
            this.setToolTipText((String)toolTip);
        } else {
            this.setToolTipText(null);
        }
        this.m_disIcon = RmaImage.getDisabledIcon(this.m_icon);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("enabled".equals(evt.getPropertyName())) {
            this.setEnabled(Boolean.TRUE.equals(evt.getNewValue()));
        } else if ("SmallIcon".equals(evt.getPropertyName())) {
            this.setIcon((Icon)this.m_action.getValue("SmallIcon"));
        }
    }

    class ActionPMenuListener
    implements PopupMenuListener {
        @Override
        public void popupMenuCanceled(PopupMenuEvent popupmenuevent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupmenuevent) {
            ActionButton.this.m_popupPressed = false;
            GLOBAL_MENU_PRESSED = false;
            ActionButton.this.repaint();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupmenuevent) {
        }
    }
}

