/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class RmaCompTitledBorder
extends TitledBorder {
    protected JComponent _component;

    public RmaCompTitledBorder(JComponent component) {
        this(null, component, 1, 2);
    }

    public RmaCompTitledBorder(Border border) {
        this(border, (JComponent)null, 1, 2);
    }

    public RmaCompTitledBorder(Border border, JComponent component) {
        this(border, component, 1, 2);
    }

    public RmaCompTitledBorder(Border border, JComponent component, int titleJustification, int titlePosition) {
        super(border, null, titleJustification, titlePosition, null, null);
        this._component = component;
        if (border == null) {
            this.border = super.getBorder();
        }
    }

    @Override
    public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
        Rectangle borderR = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        Insets borderInsets = this.border != null ? this.border.getBorderInsets(c2) : new Insets(0, 0, 0, 0);
        Rectangle rect = new Rectangle(x, y, width, height);
        Insets insets = this.getBorderInsets(c2);
        Rectangle compR = this.getComponentRect(rect, insets);
        switch (this.titlePosition) {
            case 1: {
                int diff = compR.height + 2;
                borderR.y += diff;
                borderR.height -= diff;
                break;
            }
            case 0: 
            case 2: {
                int diff = insets.top / 2 - borderInsets.top - 2;
                borderR.y += diff;
                borderR.height -= diff;
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                int diff = insets.bottom / 2 - borderInsets.bottom - 2;
                borderR.height -= diff;
                break;
            }
            case 6: {
                int diff = compR.height + 2;
                borderR.height -= diff;
            }
        }
        this.border.paintBorder(c2, g, borderR.x, borderR.y, borderR.width, borderR.height);
        Color col = g.getColor();
        g.setColor(c2.getBackground());
        g.fillRect(compR.x, compR.y, compR.width, compR.height);
        g.setColor(col);
    }

    @Override
    public Insets getBorderInsets(Component c2, Insets insets) {
        Insets borderInsets = this.border != null ? this.border.getBorderInsets(c2) : new Insets(0, 0, 0, 0);
        insets.top = 4 + borderInsets.top;
        insets.right = 4 + borderInsets.right;
        insets.bottom = 4 + borderInsets.bottom;
        insets.left = 4 + borderInsets.left;
        if (c2 == null || this._component == null) {
            return insets;
        }
        int compHeight = 0;
        if (this._component != null) {
            compHeight = this._component.getPreferredSize().height;
        }
        switch (this.titlePosition) {
            case 1: {
                insets.top += compHeight + 2;
                break;
            }
            case 0: 
            case 2: {
                insets.top += Math.max(compHeight, borderInsets.top) - borderInsets.top;
                break;
            }
            case 3: {
                insets.top += compHeight + 2;
                break;
            }
            case 4: {
                insets.bottom += compHeight + 2;
                break;
            }
            case 5: {
                insets.bottom += Math.max(compHeight, borderInsets.bottom) - borderInsets.bottom;
                break;
            }
            case 6: {
                insets.bottom += compHeight + 2;
            }
        }
        return insets;
    }

    public JComponent getTitleComponent() {
        return this._component;
    }

    public void setTitleComponent(JComponent component) {
        this._component = component;
    }

    public Rectangle getComponentRect(Rectangle rect, Insets borderInsets) {
        Dimension compD = this._component.getPreferredSize();
        Rectangle compR = new Rectangle(0, 0, compD.width, compD.height);
        switch (this.titlePosition) {
            case 1: {
                compR.y = 2;
                break;
            }
            case 0: 
            case 2: {
                compR.y = 2 + (borderInsets.top - 2 - 2 - compD.height) / 2;
                break;
            }
            case 3: {
                compR.y = borderInsets.top - compD.height - 2;
                break;
            }
            case 4: {
                compR.y = rect.height - borderInsets.bottom + 2;
                break;
            }
            case 5: {
                compR.y = rect.height - borderInsets.bottom + 2 + (borderInsets.bottom - 2 - 2 - compD.height) / 2;
                break;
            }
            case 6: {
                compR.y = rect.height - compD.height - 2;
            }
        }
        switch (this.titleJustification) {
            case 0: 
            case 1: {
                compR.x = 5 + borderInsets.left;
                break;
            }
            case 3: {
                compR.x = rect.width - borderInsets.right - 5 - compR.width;
                break;
            }
            case 2: {
                compR.x = (rect.width - compR.width) / 2;
            }
        }
        return compR;
    }
}

