/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.colorchooser;

import java.awt.Color;
import java.io.Serializable;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DefaultColorSelectionModel
implements ColorSelectionModel,
Serializable {
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    private Color selectedColor;

    public DefaultColorSelectionModel() {
        this.selectedColor = Color.white;
    }

    public DefaultColorSelectionModel(Color color) {
        this.selectedColor = color;
    }

    @Override
    public Color getSelectedColor() {
        return this.selectedColor;
    }

    @Override
    public void setSelectedColor(Color color) {
        if (color != null && !this.selectedColor.equals(color)) {
            this.selectedColor = color;
            this.fireStateChanged();
        }
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

