/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.colorchooser.CenterLayout;
import rma.swing.colorchooser.SmartGridLayout;

public class DefaultRGBAChooserPanel
extends AbstractColorChooserPanel
implements ChangeListener {
    protected JSlider redSlider;
    protected JSlider greenSlider;
    protected JSlider blueSlider;
    protected JSlider alphaSlider;
    protected JSpinner redField;
    protected JSpinner blueField;
    protected JSpinner greenField;
    protected JSpinner alphaField;
    private final int minValue = 0;
    private final int maxValue = 255;
    private int alpha = 255;
    private boolean isAdjusting = false;

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    private void setColor(Color newColor) {
        int red = newColor.getRed();
        int blue = newColor.getBlue();
        int green = newColor.getGreen();
        int alpha = newColor.getAlpha();
        if (this.redSlider.getValue() != red) {
            this.redSlider.setValue(red);
        }
        if (this.greenSlider.getValue() != green) {
            this.greenSlider.setValue(green);
        }
        if (this.blueSlider.getValue() != blue) {
            this.blueSlider.setValue(blue);
        }
        if (this.alphaSlider.getValue() != alpha) {
            this.alphaSlider.setValue(alpha);
        }
        if ((Integer)this.redField.getValue() != red) {
            this.redField.setValue(new Integer(red));
        }
        if ((Integer)this.greenField.getValue() != green) {
            this.greenField.setValue(new Integer(green));
        }
        if ((Integer)this.blueField.getValue() != blue) {
            this.blueField.setValue(new Integer(blue));
        }
        if ((Integer)this.alphaField.getValue() != alpha) {
            this.alphaField.setValue(new Integer(alpha));
        }
    }

    @Override
    public String getDisplayName() {
        return "RGBA";
    }

    @Override
    public int getMnemonic() {
        return DefaultRGBAChooserPanel.getInt("ColorChooser.rgbMnemonic", -1);
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return DefaultRGBAChooserPanel.getInt("ColorChooser.rgbDisplayedMnemonicIndex", -1);
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
    }

    @Override
    protected void buildChooser() {
        String redString = UIManager.getString("ColorChooser.rgbRedText");
        String greenString = UIManager.getString("ColorChooser.rgbGreenText");
        String blueString = UIManager.getString("ColorChooser.rgbBlueText");
        String alphaString = "Alpha";
        this.setLayout(new BorderLayout());
        Color color = this.getColorFromModel();
        JPanel enclosure = new JPanel();
        enclosure.setLayout(new SmartGridLayout(3, 4));
        this.add((Component)enclosure, "Center");
        JLabel l = new JLabel(redString);
        l.setDisplayedMnemonic(UIManager.getInt("ColorChooser.rgbRedMnemonic"));
        enclosure.add(l);
        this.redSlider = new JSlider(0, 0, 255, color.getRed());
        this.redSlider.setMajorTickSpacing(85);
        this.redSlider.setMinorTickSpacing(17);
        this.redSlider.setPaintTicks(true);
        this.redSlider.setPaintLabels(true);
        enclosure.add(this.redSlider);
        this.redField = new JSpinner(new SpinnerNumberModel(color.getRed(), 0, 255, 1));
        l.setLabelFor(this.redSlider);
        JPanel redFieldHolder = new JPanel(new CenterLayout());
        this.redField.addChangeListener(this);
        redFieldHolder.add(this.redField);
        enclosure.add(redFieldHolder);
        l = new JLabel(greenString);
        l.setDisplayedMnemonic(UIManager.getInt("ColorChooser.rgbGreenMnemonic"));
        enclosure.add(l);
        this.greenSlider = new JSlider(0, 0, 255, color.getGreen());
        this.greenSlider.setMajorTickSpacing(85);
        this.greenSlider.setMinorTickSpacing(17);
        this.greenSlider.setPaintTicks(true);
        this.greenSlider.setPaintLabels(true);
        enclosure.add(this.greenSlider);
        this.greenField = new JSpinner(new SpinnerNumberModel(color.getGreen(), 0, 255, 1));
        l.setLabelFor(this.greenSlider);
        JPanel greenFieldHolder = new JPanel(new CenterLayout());
        greenFieldHolder.add(this.greenField);
        this.greenField.addChangeListener(this);
        enclosure.add(greenFieldHolder);
        l = new JLabel(blueString);
        l.setDisplayedMnemonic(UIManager.getInt("ColorChooser.rgbBlueMnemonic"));
        enclosure.add(l);
        this.blueSlider = new JSlider(0, 0, 255, color.getBlue());
        this.blueSlider.setMajorTickSpacing(85);
        this.blueSlider.setMinorTickSpacing(17);
        this.blueSlider.setPaintTicks(true);
        this.blueSlider.setPaintLabels(true);
        enclosure.add(this.blueSlider);
        this.blueField = new JSpinner(new SpinnerNumberModel(color.getBlue(), 0, 255, 1));
        l.setLabelFor(this.blueSlider);
        JPanel blueFieldHolder = new JPanel(new CenterLayout());
        blueFieldHolder.add(this.blueField);
        this.blueField.addChangeListener(this);
        enclosure.add(blueFieldHolder);
        l = new JLabel(alphaString);
        l.setDisplayedMnemonic(UIManager.getInt("ColorChooser.rgbBlueMnemonic"));
        enclosure.add(l);
        this.alphaSlider = new JSlider(0, 0, 255, this.alpha);
        this.alphaSlider.setMajorTickSpacing(85);
        this.alphaSlider.setMinorTickSpacing(17);
        this.alphaSlider.setPaintTicks(true);
        this.alphaSlider.setPaintLabels(true);
        enclosure.add(this.alphaSlider);
        this.alphaField = new JSpinner(new SpinnerNumberModel(this.alpha, 0, 255, 1));
        l.setLabelFor(this.alphaSlider);
        JPanel alphaFieldHolder = new JPanel(new CenterLayout());
        alphaFieldHolder.add(this.alphaField);
        this.alphaField.addChangeListener(this);
        enclosure.add(alphaFieldHolder);
        this.alphaSlider.addChangeListener(this);
        this.redSlider.addChangeListener(this);
        this.greenSlider.addChangeListener(this);
        this.blueSlider.addChangeListener(this);
        this.alphaSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.redSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.greenSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.blueSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
    }

    @Override
    public void updateChooser() {
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            this.setColor(this.getColorFromModel());
            this.isAdjusting = false;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JSlider && !this.isAdjusting) {
            int red = this.redSlider.getValue();
            int green = this.greenSlider.getValue();
            int blue = this.blueSlider.getValue();
            int alpha = this.alphaSlider.getValue();
            Color color = new Color(red, green, blue, alpha);
            this.getColorSelectionModel().setSelectedColor(color);
        } else if (e.getSource() instanceof JSpinner && !this.isAdjusting) {
            int red = (Integer)this.redField.getValue();
            int green = (Integer)this.greenField.getValue();
            int blue = (Integer)this.blueField.getValue();
            int alpha = (Integer)this.alphaField.getValue();
            Color color = new Color(red, green, blue, alpha);
            this.getColorSelectionModel().setSelectedColor(color);
        }
    }

    static int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

