/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.colorchooser;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;
import rma.swing.RmaImage;

public class PointedSliderUi
extends BasicSliderUI {
    private final BufferedImage _image;

    public PointedSliderUi(JSlider slider, boolean reversedThumb) {
        super(slider);
        ImageIcon imageIcon = RmaImage.getImageIcon("Images/Thumb.png");
        if (imageIcon == null) {
            Logger.getLogger(PointedSliderUi.class.getName()).log(Level.INFO, "Image retrieved for Images/Thumb.png returned null.");
            this._image = null;
        } else {
            Image image = imageIcon.getImage();
            BufferedImage original = null;
            if (image instanceof BufferedImage) {
                original = (BufferedImage)image;
            } else if (image != null) {
                original = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                Graphics2D g2d = original.createGraphics();
                g2d.drawImage(image, 0, 0, null);
                g2d.dispose();
            }
            if (original == null) {
                Logger.getLogger(PointedSliderUi.class.getName()).log(Level.INFO, "Image retrieved for Images/Thumb.png is null.");
                this._image = null;
            } else {
                boolean isHorizontal = slider.getOrientation() == 0;
                double rotation = 0.0;
                if (reversedThumb) {
                    rotation += 180.0;
                }
                if (isHorizontal) {
                    rotation += 90.0;
                }
                AffineTransform scaleInstance = AffineTransform.getRotateInstance(Math.toRadians(rotation), original.getWidth() / 2, original.getHeight() / 2);
                AffineTransformOp op = new AffineTransformOp(scaleInstance, 2);
                this._image = new BufferedImage(original.getWidth(), original.getHeight(), original.getType());
                op.filter(original, this._image);
            }
        }
    }

    @Override
    public void paint(Graphics g, JComponent c2) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        super.paint(g2d, c2);
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(14, 12);
    }

    @Override
    public void paintThumb(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        if (this._image != null) {
            g2d.drawImage((Image)this._image, this.thumbRect.x + 2, this.thumbRect.y, null);
        }
        g2d.dispose();
    }
}

