/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.colorchooser;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import rma.swing.colorchooser.SyntheticImageGenerator;

abstract class SyntheticImage
implements ImageProducer {
    private SyntheticImageGenerator root;
    protected int width = 10;
    protected int height = 100;
    static final ColorModel cm = ColorModel.getRGBdefault();
    public static final int pixMask = 255;
    private Thread runner;
    protected volatile boolean aborted = false;

    protected SyntheticImage() {
    }

    protected SyntheticImage(int w, int h) {
        this.width = w;
        this.height = h;
    }

    protected void computeRow(int y, int[] row) {
        int p = 255 - 255 * y / (this.height - 1);
        p = 0xFF000000 | p << 16 | p << 8 | p;
        int i = row.length;
        while (--i >= 0) {
            row[i] = p;
        }
    }

    @Override
    public synchronized void addConsumer(ImageConsumer ic) {
        SyntheticImageGenerator ics = this.root;
        while (ics != null) {
            if (ics.ic == ic) {
                return;
            }
            ics = ics.next;
        }
        this.root = new SyntheticImageGenerator(ic, this.root, this);
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer ic) {
        SyntheticImageGenerator ics = this.root;
        while (ics != null) {
            if (ics.ic == ic) {
                return true;
            }
            ics = ics.next;
        }
        return false;
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer ic) {
        Object prev = null;
        SyntheticImageGenerator ics = this.root;
        while (ics != null) {
            if (ics.ic == ic) {
                ics.useful = false;
                if (prev != null) {
                    prev.next = ics.next;
                } else {
                    this.root = ics.next;
                }
                return;
            }
            ics = ics.next;
        }
    }

    @Override
    public synchronized void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
        SyntheticImageGenerator ics = this.root;
        while (ics != null) {
            if (ics.useful && !ics.isAlive()) {
                ics.start();
            }
            ics = ics.next;
        }
    }

    protected boolean isStatic() {
        return true;
    }

    public void nextFrame(int param) {
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }
}

