/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.event;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ReflectMultiListener
implements ActionListener,
ChangeListener,
ItemListener {
    HashMap _methodMap = new HashMap();
    static Class[] NO_CLASS_ARGS = new Class[0];
    static Object[] NO_OBJECT_ARGS = new Object[0];
    private static final int SUCCESS = 0;
    private static final int EXCEPTION = 1;
    private static final int ACCESS_FAILED = 2;
    private int _modifiers;

    public ReflectMultiListener() {
    }

    public ReflectMultiListener(Object methodContainer, Object source, String methodName) {
        this.add(methodContainer, source, methodName);
    }

    public ReflectMultiListener add(Object methodContainer, Object source, String methodName) {
        this._methodMap.put(source, new ObjectMethodItem(methodContainer, methodName));
        return this;
    }

    public void remove(Object source) {
        this._methodMap.remove(source);
    }

    public int getModifiers() {
        return this._modifiers;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this._modifiers = 0;
        this.fireMethodCall(event.getSource());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this._modifiers = event.getModifiers();
        this.fireMethodCall(event.getSource());
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        this._modifiers = 0;
        if (event.getStateChange() == 2) {
            return;
        }
        this.fireMethodCall(event.getSource());
    }

    private void fireMethodCall(Object src) {
        boolean accessible;
        Class<?> c2;
        if (src == null) {
            return;
        }
        ObjectMethodItem item = (ObjectMethodItem)this._methodMap.get(src);
        if (item == null) {
            return;
        }
        if (item.methodName == null || item.object == null) {
            return;
        }
        if (item.method == null && !this.findMethodCall(c2 = item.object.getClass(), item.methodName, item)) {
            System.out.println("Error finding method " + item.methodName + " in class " + c2.getName());
            return;
        }
        if (this.fireMethodCall(item, false) == 2 && !(accessible = item.method.isAccessible())) {
            item.method.setAccessible(true);
            this.fireMethodCall(item, true);
            if (item.method.isAccessible() != accessible) {
                item.method.setAccessible(accessible);
            }
        }
    }

    private int fireMethodCall(ObjectMethodItem item, boolean printAccessMessage) {
        try {
            item.method.invoke(item.object, NO_OBJECT_ARGS);
        }
        catch (InvocationTargetException ite) {
            System.out.println("actionPerformed:error in " + item.method.getName() + " Error " + ite.getTargetException());
            ite.getTargetException().printStackTrace();
            return 1;
        }
        catch (IllegalAccessException iea) {
            if (printAccessMessage && !Modifier.isPublic(item.method.getModifiers())) {
                System.out.println(item.method.getName() + " method is not public");
            }
            return 2;
        }
        catch (Exception ee) {
            System.out.println("actionPerformed:error invoking " + item.method.getName() + " Error " + ee);
            return 1;
        }
        return 0;
    }

    private boolean findMethodCall(Class cls, String methodName, ObjectMethodItem item) {
        if (cls == null || methodName == null) {
            return false;
        }
        try {
            item.method = cls.getDeclaredMethod(methodName, NO_CLASS_ARGS);
            return true;
        }
        catch (Exception e) {
            Class c2 = cls.getSuperclass();
            if (c2 != null) {
                return this.findMethodCall(c2, methodName, item);
            }
            return false;
        }
    }

    public class ObjectMethodItem {
        Object object;
        String methodName;
        Method method;

        public ObjectMethodItem(Object obj, String name) {
            this.object = obj;
            this.methodName = name;
        }
    }
}

