/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.list;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import rma.swing.list.CheckableListItem;

public class CheckListRenderer
extends JCheckBox
implements ListCellRenderer {
    public CheckListRenderer() {
        this.setBackground(UIManager.getColor("List.textBackground"));
        this.setForeground(UIManager.getColor("List.textForeground"));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
        } else {
            this.setBorder(null);
        }
        this.setEnabled(list.isEnabled());
        if (isSelected) {
            this.setBackground(UIManager.getColor("List.selectionBackground"));
            this.setForeground(UIManager.getColor("List.selectionForeground"));
        } else {
            this.setBackground(UIManager.getColor("List.textBackground"));
            this.setForeground(UIManager.getColor("List.textForeground"));
        }
        this.setFont(list.getFont());
        this.setText(value.toString());
        if (value instanceof CheckableListItem) {
            this.setSelected(((CheckableListItem)value).isSelected());
        } else {
            this.setSelected(false);
        }
        return this;
    }
}

