/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.list;

import java.awt.Component;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import rma.swing.RmaImage;
import rma.util.RMAIO;

public class ImageFileCellRenderer
extends JLabel
implements ListCellRenderer {
    JComboBox _combobox;
    HashMap _cache = null;

    public ImageFileCellRenderer(JComboBox x) {
        this._combobox = x;
        this.setOpaque(true);
        this._cache = new HashMap();
    }

    public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setOpaque(true);
        if (isSelected) {
            this.setBackground(UIManager.getColor("ComboBox.selectedBackground"));
            this.setForeground(UIManager.getColor("ComboBox.selectedForeground"));
        } else {
            this.setBackground(UIManager.getColor("ComboBox.background"));
            this.setForeground(UIManager.getColor("ComboBox.foreground"));
        }
        if (value == null) {
            this.setText("");
            this.setIcon(null);
        } else {
            String name = value.toString();
            IconNameItem iconItem = (IconNameItem)this._cache.get(name);
            if (iconItem == null) {
                ImageIcon icon;
                iconItem = new IconNameItem();
                iconItem.icon = icon = RmaImage.getImageIcon(name);
                String displayedName = RMAIO.getFileFromPath(name);
                int idx = displayedName.lastIndexOf(".");
                iconItem.displayedName = idx > -1 ? displayedName.substring(0, idx) : displayedName;
                this._cache.put(name, iconItem);
            }
            this.setIcon(iconItem.icon);
            this.setText(iconItem.displayedName);
        }
        return this;
    }

    public class IconNameItem {
        public ImageIcon icon;
        public String displayedName;
    }
}

