/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.list;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public class RmaListCellRenderer
extends JLabel
implements ListCellRenderer {
    protected static Border noFocusBorder;

    public RmaListCellRenderer() {
        noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    public Component getListCellRendererComponent(JList list, Object value, int modelIndex, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof JLabel) {
            JLabel comp = (JLabel)value;
            this.setupComp(list, comp, cellHasFocus, isSelected);
            return comp;
        }
        if (value instanceof JCheckBox) {
            JCheckBox comp = (JCheckBox)value;
            this.setupComp(list, comp, cellHasFocus, isSelected);
            return comp;
        }
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
        } else {
            if (value instanceof JTextComponent) {
                JTextComponent comp = (JTextComponent)value;
                this.setupComp(list, comp, cellHasFocus, isSelected);
                return comp;
            }
            this.setText(value == null ? "" : value.toString());
        }
        this.setupComp(list, this, cellHasFocus, isSelected);
        return this;
    }

    private void setupComp(JList list, JComponent comp, boolean cellHasFocus, boolean isSelected) {
        comp.setEnabled(list.isEnabled());
        comp.setFont(list.getFont());
        comp.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
        if (isSelected) {
            comp.setBackground(list.getSelectionBackground());
            comp.setForeground(list.getSelectionForeground());
        } else {
            comp.setBackground(list.getBackground());
            comp.setForeground(list.getForeground());
        }
    }
}

