/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.list;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import org.apache.commons.collections4.IteratorUtils;
import rma.util.Compare;
import rma.util.Contains;
import rma.util.RMASort;

public class RmaListModel<E>
extends AbstractListModel<E>
implements MutableComboBoxModel<E>,
Serializable {
    protected boolean _ascendingSort = true;
    protected boolean _enableSort = false;
    protected boolean _caseInsensitiveSort = false;
    protected Object _selectedObject;
    protected List<E> delegate = new Vector();

    public RmaListModel() {
    }

    public RmaListModel(boolean enableSort) {
        this._enableSort = enableSort;
    }

    public RmaListModel(boolean enableSort, Collection<E> items) {
        this(enableSort);
        this.addAll(items);
    }

    public RmaListModel(boolean enableSort, E ... items) {
        this(enableSort);
        this.addAll(items);
    }

    public void setAscendingSort(boolean tf) {
        this._ascendingSort = tf;
    }

    public boolean isAscendingSort() {
        return this._ascendingSort;
    }

    @Override
    public int getSize() {
        return this.delegate.size();
    }

    @Override
    public E getElementAt(int index) {
        return this.delegate.get(index);
    }

    public void copyInto(Object[] anArray) {
        this.delegate.toArray(anArray);
    }

    @Deprecated
    public void trimToSize() {
        if (this.delegate instanceof Vector) {
            ((Vector)this.delegate).trimToSize();
        }
    }

    @Deprecated
    public void ensureCapacity(int minCapacity) {
        if (this.delegate instanceof Vector) {
            ((Vector)this.delegate).ensureCapacity(minCapacity);
        }
    }

    @Deprecated
    public void setSize(int newSize) {
        if (!(this.delegate instanceof Vector)) {
            return;
        }
        int oldSize = this.delegate.size();
        ((Vector)this.delegate).setSize(newSize);
        if (oldSize > newSize) {
            this.fireIntervalRemoved(this, newSize, oldSize - 1);
        } else if (oldSize < newSize) {
            this.fireIntervalAdded(this, oldSize, newSize - 1);
        }
    }

    @Deprecated
    public int capacity() {
        if (this.delegate instanceof Vector) {
            return ((Vector)this.delegate).capacity();
        }
        return this.delegate.size();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Deprecated
    public Enumeration<E> elements() {
        return IteratorUtils.asEnumeration(this.delegate.iterator());
    }

    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    public boolean contains(Object elem) {
        return this.delegate.contains(elem);
    }

    public int firstIndexOf(String match, int index, boolean wrap, boolean wholeWord, boolean caseSensitive) {
        int ii;
        if (index < 0 || index >= this.delegate.size()) {
            return -1;
        }
        Contains contains = new Contains(wholeWord);
        if (!caseSensitive) {
            match = match.toUpperCase();
        }
        for (ii = index; ii < this.delegate.size(); ++ii) {
            if (!this.matchDelegateIndex(ii, match, caseSensitive, contains)) continue;
            return ii;
        }
        if (!wrap) {
            return -1;
        }
        for (ii = 0; ii < index; ++ii) {
            if (!this.matchDelegateIndex(ii, match, caseSensitive, contains)) continue;
            return ii;
        }
        return -1;
    }

    public int lastIndexOf(String match, int index, boolean wholeWord, boolean caseSensitive) {
        if (index < 0 || index >= this.delegate.size()) {
            return -1;
        }
        Contains contains = new Contains(wholeWord);
        if (!caseSensitive) {
            match = match.toUpperCase();
        }
        for (int ii = index; ii >= 0; --ii) {
            if (!this.matchDelegateIndex(ii, match, caseSensitive, contains)) continue;
            return ii;
        }
        return -1;
    }

    private boolean matchDelegateIndex(int delegateIndex, String match, boolean caseSensitive, Contains contains) {
        E delegateItem = this.delegate.get(delegateIndex);
        if (delegateItem == null) {
            return false;
        }
        String delegateString = delegateItem.toString();
        if (!caseSensitive) {
            delegateString = delegateString.toUpperCase();
        }
        return contains.contains(delegateString, match);
    }

    public int indexOf(Object elem) {
        return this.delegate.indexOf(elem);
    }

    @Deprecated
    public int indexOf(Object elem, int index) {
        if (this.delegate instanceof Vector) {
            return ((Vector)this.delegate).indexOf(elem, index);
        }
        return -1;
    }

    public int lastIndexOf(Object elem) {
        return this.delegate.lastIndexOf(elem);
    }

    @Deprecated
    public int lastIndexOf(Object elem, int index) {
        if (this.delegate instanceof Vector) {
            return ((Vector)this.delegate).lastIndexOf(elem, index);
        }
        return -1;
    }

    public Object get(int index) {
        return this.delegate.get(index);
    }

    public int getIndexOf(Object anObject) {
        return this.delegate.indexOf(anObject);
    }

    @Deprecated
    public Object firstElement() {
        try {
            return this.delegate.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Deprecated
    public Object lastElement() {
        try {
            return this.delegate.get(this.delegate.size() - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    public void setElementAt(E obj, int index) {
        this.delegate.set(index, obj);
        this.fireContentsChanged(this, index, index);
    }

    @Override
    public void removeElementAt(int index) {
        E o = this.delegate.get(index);
        this.delegate.remove(index);
        this.fireIntervalRemoved(this, index, index);
        if (this._selectedObject == o) {
            this._selectedObject = null;
        }
    }

    @Override
    public void insertElementAt(E obj, int index) {
        this.delegate.add(index, obj);
        this.fireIntervalAdded(this, index, index);
    }

    public boolean checkComparable(List list) {
        if (list == null) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof Comparable) continue;
            return false;
        }
        return true;
    }

    public boolean getCaseInsensitiveSort() {
        return this._caseInsensitiveSort;
    }

    public void setCaseInsensitiveSort(boolean caseInsensitiveSort) {
        this._caseInsensitiveSort = caseInsensitiveSort;
    }

    public boolean sort() {
        if (!this._enableSort) {
            return false;
        }
        if (this.checkComparable(this.delegate)) {
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    String so2;
                    String so1;
                    if (RmaListModel.this._caseInsensitiveSort) {
                        so1 = o1.toString().toUpperCase();
                        so2 = o2.toString().toUpperCase();
                    } else {
                        so1 = o1.toString();
                        so2 = o2.toString();
                    }
                    int val = so1.compareTo(so2);
                    if (!RmaListModel.this._ascendingSort) {
                        val *= -1;
                    }
                    return val;
                }

                @Override
                public boolean equals(Object obj) {
                    if (obj == null) {
                        return false;
                    }
                    return this.toString().equalsIgnoreCase(obj.toString());
                }
            };
            Collections.sort(this.delegate, comparator);
        } else if (this._caseInsensitiveSort) {
            Compare compare = new Compare(){

                @Override
                public int compare(Object a, Object b, boolean ascending) {
                    String so1 = a.toString().toUpperCase();
                    String so2 = b.toString().toUpperCase();
                    return so1.compareTo(so2);
                }
            };
            RMASort.quickSort(this.delegate, this._ascendingSort, compare);
        } else {
            RMASort.quickSort(this.delegate, this._ascendingSort);
        }
        return true;
    }

    public void addElements(E[] objs) {
        if (objs == null || objs.length < 1) {
            return;
        }
        int index = 0;
        int lastIndex = 0;
        index = this.delegate.size();
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            this.delegate.add(objs[i]);
        }
        lastIndex = this.delegate.size() - 1;
        if (this.sort()) {
            index = 0;
            lastIndex = this.delegate.size() - 1;
            this.fireContentsChanged(this, index, lastIndex);
            return;
        }
        this.fireIntervalAdded(this, index, lastIndex);
    }

    @Override
    public void addElement(E obj) {
        int index = this.addElementPrivate(obj);
        if (index < 0) {
            return;
        }
        this.fireIntervalAdded(this, index, index);
    }

    private int addElementPrivate(E obj) {
        int index = this.delegate.size();
        if (this.delegate.contains(obj)) {
            return -1;
        }
        if (this._enableSort && index > 0) {
            boolean inserted = false;
            for (index = 0; index < this.delegate.size(); ++index) {
                if (this.compare(obj, this.delegate.get(index)) >= 0) continue;
                this.delegate.add(index, obj);
                inserted = true;
                break;
            }
            if (!inserted) {
                this.delegate.add(obj);
            }
        } else {
            this.delegate.add(obj);
        }
        return index;
    }

    protected int compare(Object newObj, Object existingObj) {
        if (this._caseInsensitiveSort) {
            return newObj.toString().toUpperCase().compareTo(existingObj.toString().toUpperCase());
        }
        return newObj.toString().compareTo(existingObj.toString());
    }

    @Override
    public void removeElement(Object obj) {
        int index = this.indexOf(obj);
        boolean rv = this.delegate.remove(obj);
        if (index >= 0) {
            this.fireIntervalRemoved(this, index, index);
        }
        if (this._selectedObject == obj) {
            this._selectedObject = null;
        }
    }

    public void removeElements(Object[] objs) {
        if (objs == null || objs.length < 1) {
            return;
        }
        int index = this.indexOf(objs[0]);
        int lastIndex = this.indexOf(objs[objs.length - 1]);
        for (int i = 0; i < objs.length; ++i) {
            int tmp;
            if (objs[i] == null || (tmp = this.indexOf(objs[i])) < 0) continue;
            this.delegate.remove(objs[i]);
            index = Math.min(index, tmp);
            lastIndex = Math.max(lastIndex, tmp);
            if (this._selectedObject != objs[i]) continue;
            this._selectedObject = null;
        }
        this.fireIntervalRemoved(this, index, lastIndex);
    }

    public void removeAllElements() {
        int index1 = this.delegate.size() - 1;
        this.delegate.clear();
        if (index1 >= 0) {
            this.fireIntervalRemoved(this, 0, index1);
        }
        this._selectedObject = null;
    }

    public Object[] toArray() {
        Object[] rv = new Object[this.delegate.size()];
        this.delegate.toArray(rv);
        return rv;
    }

    public Object elementAt(int index) {
        return this.delegate.get(index);
    }

    public Object set(int index, E element) {
        E rv = this.delegate.get(index);
        this.delegate.set(index, element);
        this.fireContentsChanged(this, index, index);
        return rv;
    }

    public void add(int index, E element) {
        this.delegate.add(index, element);
        this.fireIntervalAdded(this, index, index);
    }

    public Object remove(int index) {
        E rv = this.delegate.get(index);
        this.delegate.remove(index);
        this.fireIntervalRemoved(this, index, index);
        if (this._selectedObject == rv) {
            this._selectedObject = null;
        }
        return rv;
    }

    public void clear() {
        int index1 = this.delegate.size() - 1;
        this.delegate.clear();
        if (index1 >= 0) {
            this.fireIntervalRemoved(this, 0, index1);
        }
    }

    public void removeRange(int fromIndex, int toIndex) {
        for (int i = toIndex; i >= fromIndex; --i) {
            E o = this.delegate.get(i);
            this.delegate.remove(i);
            if (this._selectedObject != o) continue;
            this._selectedObject = null;
        }
        this.fireIntervalRemoved(this, fromIndex, toIndex);
    }

    public void setEnableSort(boolean enableSort) {
        this._enableSort = enableSort;
    }

    public boolean isEnableSort() {
        return this._enableSort;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (this._selectedObject != null && !this._selectedObject.equals(anObject) || this._selectedObject == null && anObject != null) {
            this._selectedObject = anObject;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this._selectedObject;
    }

    public int getSelectedIndex() {
        return this.delegate.indexOf(this._selectedObject);
    }

    public void setAll(E[] o) {
        if (o == null) {
            return;
        }
        this.delegate.clear();
        int i = 0;
        for (i = 0; i < o.length; ++i) {
            this.addElementPrivate(o[i]);
        }
        this.fireContentsChanged(this, 0, o.length);
    }

    public void setAll(Collection<? extends E> c2) {
        int size = this.delegate.size();
        this.delegate.clear();
        if (c2 == null) {
            this.fireContentsChanged(this, 0, size);
            return;
        }
        for (E obj : c2) {
            this.delegate.add(obj);
        }
        this.sort();
        this.fireContentsChanged(this, 0, c2.size());
    }

    public void addAll(Collection<? extends E> c2) {
        if (c2 == null || c2.isEmpty()) {
            return;
        }
        Iterator<E> iter = c2.iterator();
        int startIndex = this.delegate.size();
        while (iter.hasNext()) {
            this.delegate.add(iter.next());
        }
        int endIndex = this.delegate.size() - 1;
        if (endIndex < 0) {
            endIndex = 0;
        }
        if (this.sort()) {
            startIndex = 0;
            this.fireContentsChanged(this, startIndex, endIndex);
            return;
        }
        this.fireIntervalAdded(this, startIndex, endIndex);
    }

    public void addAll(Object[] o) {
        if (o == null || o.length == 0) {
            return;
        }
        int startIndex = this.delegate.size();
        for (int i = 0; i < o.length; ++i) {
            if (o[i] == null) continue;
            this.delegate.add(o[i]);
        }
        int endIndex = this.delegate.size() - 1;
        if (this.sort()) {
            startIndex = 0;
            this.fireContentsChanged(this, startIndex, endIndex);
            return;
        }
        this.fireIntervalAdded(this, startIndex, endIndex);
    }

    public Vector<E> getVector() {
        return new Vector<E>(this.delegate);
    }

    public List<E> getList() {
        return (List)((Vector)this.delegate).clone();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.delegate.size(); ++i) {
            buf.append(this.delegate.get(i).toString()).append("\n");
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        System.out.println("Generating test strings");
        Vector<String> v1 = new Vector<String>();
        Vector v2 = new Vector();
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            v1.addElement(Double.toString(random.nextDouble() * 100000.0));
        }
        Object[] obj = new Object[v1.size()];
        v1.copyInto(obj);
        RmaListModel<Object> model = new RmaListModel<Object>(true);
        System.out.println("Testing addElements");
        model.addElements(obj);
        System.out.println("Testing addAll (Collection)");
        model.addAll(v1);
        System.out.println(model);
        System.out.println("Testing addAll (Object[])");
        model.removeAllElements();
        model.addAll(obj);
        System.out.println(model);
        System.out.println("Testing setAll (Collection)");
        model.setAll(v1);
        System.out.println(model);
        System.out.println("Testing setAll (Object[])");
        model.setAll(obj);
        System.out.println(model);
    }

    public void fireContentsChanged(int startRowIndex, int endRowIndex) {
        super.fireContentsChanged(this, startRowIndex, endRowIndex);
    }
}

