/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import rma.util.RmaSymbol;

public class RmaSymbolRenderer
extends JLabel
implements ListCellRenderer {
    private Color _backColor = Color.blue;
    private Color _foregroundColor = Color.blue;
    private float _size = 10.0f;
    private SymbolIcon _icon = new SymbolIcon();

    public RmaSymbolRenderer() {
        this.setOpaque(true);
        this.setIcon(this._icon);
    }

    public RmaSymbolRenderer(Color fc, Color bc) {
        this();
        this.setForegroundColor(fc);
        this.setBackgroundColor(bc);
    }

    public void setBackgroundColor(Color c2) {
        if (c2 == null) {
            return;
        }
        this._backColor = c2;
    }

    public void setForegroundColor(Color c2) {
        this._foregroundColor = c2;
    }

    public void setSize(float size) {
        this._size = size;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this._icon.setBackgroundColor(this._backColor);
        this._icon.setForegroundColor(this._foregroundColor);
        this._icon.setSize(this._size);
        if (value != null) {
            this._icon.setSymbolType((Integer)value);
        } else {
            this._icon.setSymbolType(0);
        }
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        return this;
    }

    class SymbolIcon
    implements Icon {
        private Color _backColor;
        private Color _foregroundColor;
        private float _size;
        private int _symbolType;
        private int _w;
        private int _h;

        public SymbolIcon() {
            this(Color.blue, Color.blue, 50, 15);
        }

        public SymbolIcon(Color fc, Color bc) {
            this(fc, bc, 50, 15);
        }

        public SymbolIcon(Color fc, Color bc, int w, int h) {
            this._foregroundColor = fc;
            this._backColor = bc;
            this._w = w;
            this._h = h;
        }

        @Override
        public void paintIcon(Component c2, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            Graphics2D g2d = (Graphics2D)g;
            RmaSymbol.draw(g, this._w / 2, this._h / 2, this._symbolType, this._backColor, this._foregroundColor, this._size);
            g2d.setColor(oldColor);
        }

        public Color getBackgroundColor() {
            return this._backColor;
        }

        public void setBackgroundColor(Color c2) {
            if (c2 == null) {
                return;
            }
            this._backColor = c2;
        }

        public void setForegroundColor(Color c2) {
            this._foregroundColor = c2;
        }

        public void setSize(float size) {
            this._size = size;
        }

        public void setSymbolType(int symbol) {
            this._symbolType = symbol;
        }

        @Override
        public int getIconWidth() {
            return this._w;
        }

        @Override
        public int getIconHeight() {
            return this._h;
        }
    }
}

