/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.logging;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Window;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import rma.swing.logging.ILogRecordDisplay;
import rma.swing.logging.LogRecordDisplayPanel;
import rma.swing.logging.LogRecordMenuBar;

public final class DialogLogHandler
extends Handler {
    private static final DialogLogHandler INSTANCE = new DialogLogHandler();
    private static final Logger ROOT_LOGGER = Logger.getLogger("");
    private Level _showDialogLevel;
    private boolean _isModal = false;
    private boolean _isFrame = false;
    private ILogRecordDisplay _logRecordPanel;
    private Window _logRecordWindow;
    private Window _parentWindow;
    private Set<String> _ignoredSourceClassPrefixes = new HashSet<String>();
    private Set<String> _ignoredLoggerNamePrefixes = new HashSet<String>();
    private LogRecordMenuBar _logRecordMenuBar;
    private Level _bringToFrontLevel = null;
    private LogRecordDisplayProvider _displayProvider = new MyLogRecordDisplayProvider();
    private String _title = "";

    public DialogLogHandler() {
        this.init();
    }

    public void setLogDisplayProvider(LogRecordDisplayProvider provider) {
        this._displayProvider = provider;
    }

    private void init() {
        this.setLevel(Level.INFO);
        this._showDialogLevel = Level.INFO;
    }

    public static DialogLogHandler getInstance() {
        return INSTANCE;
    }

    public void attachToRootLogger() {
        ROOT_LOGGER.addHandler(this);
    }

    public void setParentWindow(Window parentWindow) {
        this._parentWindow = parentWindow;
    }

    public void disposeWindow() {
        if (this._logRecordWindow != null) {
            this._logRecordWindow.setVisible(false);
            this._logRecordWindow.dispose();
            this._logRecordWindow = null;
            this._logRecordPanel = null;
            this._logRecordMenuBar = null;
        }
    }

    private void buildWindow() {
        if (this._logRecordWindow != null) {
            return;
        }
        this._logRecordPanel = this._displayProvider.getRecordDisplayPanelInstance();
        this._logRecordPanel.clearAllLogRecords();
        this._logRecordMenuBar = new LogRecordMenuBar(this._logRecordPanel);
        this._logRecordMenuBar.buildMenu();
        if (this._isFrame) {
            List<Image> iconImages;
            this._logRecordWindow = new JFrame(this._title);
            ((JFrame)this._logRecordWindow).setJMenuBar(this._logRecordMenuBar);
            if (this._parentWindow != null && !(iconImages = this._parentWindow.getIconImages()).isEmpty()) {
                this._logRecordWindow.setIconImage(iconImages.get(0));
            }
        } else {
            if (this._parentWindow != null) {
                this._logRecordWindow = new JDialog(this._parentWindow, this._title);
            } else {
                this._logRecordWindow = new JDialog();
                ((JDialog)this._logRecordWindow).setTitle(this._title);
            }
            ((JDialog)this._logRecordWindow).setModal(this._isModal);
            ((JDialog)this._logRecordWindow).setJMenuBar(this._logRecordMenuBar);
        }
        this._logRecordWindow.setLayout(new BorderLayout());
        if (this._isFrame) {
            ((JFrame)this._logRecordWindow).getContentPane().add(this._logRecordPanel.getComponent(), "Center");
        } else {
            ((JDialog)this._logRecordWindow).getContentPane().add(this._logRecordPanel.getComponent(), "Center");
        }
        this._logRecordWindow.pack();
        this._logRecordWindow.setLocationRelativeTo(this._parentWindow);
    }

    public void bringLogWindowToFront() {
        if (this._logRecordWindow != null) {
            this._logRecordWindow.toFront();
        }
    }

    public void showErrorLogWindow() {
        this.showErrorLogWindow(null);
    }

    public void showErrorLogWindow(LogRecord logRecord) {
        EventQueue.invokeLater(() -> this.showErrorLogOnEdt(logRecord));
    }

    private void showErrorLogOnEdt(LogRecord logRecord) {
        if (this._logRecordWindow == null) {
            this.buildWindow();
        }
        if (logRecord != null) {
            this._logRecordPanel.addLogRecord(logRecord);
        }
        if (!this._logRecordWindow.isVisible() && (logRecord == null || this.accept(logRecord, this._showDialogLevel))) {
            this._logRecordWindow.setVisible(true);
        }
        if (logRecord != null && logRecord.getLevel() != null && this._bringToFrontLevel != null && logRecord.getLevel().intValue() >= this._bringToFrontLevel.intValue()) {
            EventQueue.invokeLater(() -> {
                if (this._logRecordWindow instanceof JFrame) {
                    ((JFrame)this._logRecordWindow).setState(0);
                }
                this._logRecordWindow.toFront();
            });
        }
    }

    public void setErrorLevelThatForcesDialogToFront(Level level) {
        this._bringToFrontLevel = level;
    }

    @Override
    public void publish(LogRecord record) {
        if (this.accept(record, this.getLevel())) {
            this.showErrorLogWindow(record);
        }
    }

    private boolean accept(LogRecord record, Level levelFilter) {
        boolean acceptLevel = false;
        boolean acceptSource = true;
        Level level = record.getLevel();
        if (level.intValue() >= levelFilter.intValue()) {
            acceptLevel = true;
        }
        String loggerName = record.getLoggerName();
        String sourceClass = record.getSourceClassName();
        if (loggerName == null || loggerName.isEmpty() || this.ignoreLoggerName(loggerName) || this.ignoreSourceClass(sourceClass)) {
            acceptSource = false;
        }
        return acceptLevel && acceptSource;
    }

    public Level getShowDialogLevel() {
        return this._showDialogLevel;
    }

    public void setShowDialogLevel(Level level) {
        this._showDialogLevel = level;
    }

    public void addIgnoredLoggerName(String loggerNamePrefix) {
        this._ignoredLoggerNamePrefixes.add(loggerNamePrefix);
    }

    private boolean ignoreLoggerName(String loggerName) {
        for (String loggerNamePrefix : this._ignoredLoggerNamePrefixes) {
            if (!loggerName.startsWith(loggerNamePrefix)) continue;
            return true;
        }
        return false;
    }

    public void addIgnoredSourceClass(String stringPrefix) {
        this._ignoredSourceClassPrefixes.add(stringPrefix);
    }

    private boolean ignoreSourceClass(String sourceClass) {
        for (String ignorePrefix : this._ignoredSourceClassPrefixes) {
            if (!sourceClass.startsWith(ignorePrefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public boolean isModal() {
        return this._isModal;
    }

    public void setModal(boolean isModal) {
        this._isModal = isModal;
    }

    public boolean isFrame() {
        return this._isFrame;
    }

    public void setFrame(boolean isFrame) {
        this._isFrame = isFrame;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getTitle() {
        return this._title;
    }

    public ILogRecordDisplay getLogRecordDisplay() {
        return this._logRecordPanel;
    }

    private class MyLogRecordDisplayProvider
    implements LogRecordDisplayProvider {
        private MyLogRecordDisplayProvider() {
        }

        @Override
        public ILogRecordDisplay getRecordDisplayPanelInstance() {
            return new LogRecordDisplayPanel();
        }
    }

    public static interface LogRecordDisplayProvider {
        public ILogRecordDisplay getRecordDisplayPanelInstance();
    }
}

