/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.logging;

import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.LogRecord;
import java.util.logging.XMLFormatter;

public class ImprovedXMLFormatter
extends XMLFormatter {
    private void a2(StringBuffer sb, int x) {
        if (x < 10) {
            sb.append('0');
        }
        sb.append(x);
    }

    private void appendISO8601(StringBuffer sb, long millis) {
        Date date = new Date(millis);
        sb.append(date.getYear() + 1900);
        sb.append('-');
        this.a2(sb, date.getMonth() + 1);
        sb.append('-');
        this.a2(sb, date.getDate());
        sb.append('T');
        this.a2(sb, date.getHours());
        sb.append(':');
        this.a2(sb, date.getMinutes());
        sb.append(':');
        this.a2(sb, date.getSeconds());
    }

    private void escape(StringBuffer sb, String text) {
        if (text == null) {
            text = "<null>";
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            sb.append(ch);
        }
    }

    @Override
    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer(500);
        sb.append("<record>\n");
        sb.append("  <date>");
        this.appendISO8601(sb, record.getMillis());
        sb.append("</date>\n");
        sb.append("  <millis>");
        sb.append(record.getMillis());
        sb.append("</millis>\n");
        sb.append("  <sequence>");
        sb.append(record.getSequenceNumber());
        sb.append("</sequence>\n");
        String name = record.getLoggerName();
        if (name != null) {
            sb.append("  <logger>");
            this.escape(sb, name);
            sb.append("</logger>\n");
        }
        sb.append("  <level>");
        this.escape(sb, record.getLevel().toString());
        sb.append("</level>\n");
        if (record.getSourceClassName() != null) {
            sb.append("  <class>");
            this.escape(sb, record.getSourceClassName());
            sb.append("</class>\n");
        }
        if (record.getSourceMethodName() != null) {
            sb.append("  <method>");
            this.escape(sb, record.getSourceMethodName());
            sb.append("</method>\n");
        }
        sb.append("  <thread>");
        sb.append(record.getThreadID());
        sb.append("</thread>\n");
        if (record.getMessage() != null) {
            String message = this.formatMessage(record);
            sb.append("  <message>");
            this.escape(sb, message);
            sb.append("</message>");
            sb.append("\n");
        }
        ResourceBundle bundle = record.getResourceBundle();
        try {
            if (bundle != null && bundle.getString(record.getMessage()) != null) {
                sb.append("  <key>");
                this.escape(sb, record.getMessage());
                sb.append("</key>\n");
                sb.append("  <catalog>");
                this.escape(sb, record.getResourceBundleName());
                sb.append("</catalog>\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] parameters = record.getParameters();
        if (parameters != null && parameters.length != 0 && record.getMessage().indexOf("{") == -1) {
            for (int i = 0; i < parameters.length; ++i) {
                sb.append("  <param>");
                try {
                    this.escape(sb, parameters[i].toString());
                }
                catch (Exception ex) {
                    sb.append("???");
                }
                sb.append("</param>\n");
            }
        }
        this.appendStack(sb, record.getThrown());
        sb.append("</record>\n");
        return sb.toString();
    }

    private void appendStack(StringBuffer sb, Throwable throwable) {
        if (throwable != null) {
            sb.append("  <exception>\n");
            sb.append("    <message>");
            this.escape(sb, throwable.toString());
            sb.append("</message>\n");
            StackTraceElement[] trace = throwable.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                StackTraceElement frame = trace[i];
                sb.append("    <frame>\n");
                sb.append("      <class>");
                this.escape(sb, frame.getClassName());
                sb.append("</class>\n");
                sb.append("      <method>");
                this.escape(sb, frame.getMethodName());
                sb.append("</method>\n");
                if (frame.getLineNumber() >= 0) {
                    sb.append("      <line>");
                    sb.append(frame.getLineNumber());
                    sb.append("</line>\n");
                }
                sb.append("    </frame>\n");
            }
            sb.append("  </exception>\n");
            this.appendStack(sb, throwable.getCause());
        }
    }
}

