/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.logging;

import com.google.common.flogger.FluentLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.LogManager;
import javax.swing.JOptionPane;
import rma.swing.RmaJButton;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTextField;

public final class LogManagerReloadPanel
extends RmaJPanel {
    static final String LOGGING_FILE_PROPERTY = "java.util.logging.config.file";
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private final RmaJLabel _descriptionLabel = new RmaJLabel("Logging Properties File:");
    private final RmaJTextField _loggingPropertiesFile = new RmaJTextField();
    private final RmaJButton _reloadButton = new RmaJButton("Reload");

    public LogManagerReloadPanel() {
        super(new BorderLayout());
        this.initComponents();
        this.addListeners();
    }

    private void addListeners() {
        this._reloadButton.addActionListener(e -> this.reload());
    }

    private void reload() {
        try {
            LogManager.getLogManager().readConfiguration();
            ((FluentLogger.Api)LOGGER.atInfo()).log("Logging properties file %s loaded ", (Object)this._loggingPropertiesFile.getText());
        }
        catch (IOException e) {
            String message = String.format("Could not reload logging properties file: %n%s%nError was %s", this._loggingPropertiesFile.getText(), e.getMessage());
            ((FluentLogger.Api)LOGGER.at(Level.WARNING).withCause((Throwable)e)).log(message);
            JOptionPane.showMessageDialog(this, message, "Logging Properties Reload", 0);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this._descriptionLabel, "West");
        this.add((Component)this._loggingPropertiesFile, "Center");
        this.add((Component)this._reloadButton, "East");
        this._loggingPropertiesFile.setPreferredSize(new Dimension(350, this._loggingPropertiesFile.getPreferredSize().height));
        String property = System.getProperty(LOGGING_FILE_PROPERTY, "");
        Path path = Paths.get(property, new String[0]).normalize().toAbsolutePath();
        this._loggingPropertiesFile.setText(path.toString());
        this._loggingPropertiesFile.setCaretPosition(this._loggingPropertiesFile.getDocument().getLength());
        if (!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) {
            this._loggingPropertiesFile.setEnabled(false);
            String tooltip = String.format("Could not find logging properties file. Check system property configuration for: %s", LOGGING_FILE_PROPERTY);
            this._loggingPropertiesFile.setToolTipText(tooltip);
            this._reloadButton.setEnabled(false);
        }
        this._loggingPropertiesFile.setEditable(false);
    }
}

