/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.logging;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import rma.swing.RmaInsets;
import rma.swing.logging.ILogRecordDisplay;
import rma.swing.logging.ImprovedXMLFormatter;
import rma.swing.logging.ThrownMessageStack;
import rma.swing.logging.XmlLogRecord;

public class LogRecordDisplayPanel
extends JPanel
implements ILogRecordDisplay {
    public static final String DETAILS = "DETAILS";
    public static final String SUMMARY = "SUMMARY";
    private String _currentCard;
    private List<XmlLogRecord> _logRecordList = new ArrayList<XmlLogRecord>();
    private int _currentLogIdx = 0;
    private SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyy HH:mm:ss");
    private ImprovedXMLFormatter _xmlFormatter = new ImprovedXMLFormatter();
    private JPanel cardPanel;
    private Action _saveAction;
    private JButton clearButton;
    private JButton clearAllButton;
    private JLabel currentIdxLabel;
    private JTextArea detailTextArea;
    private JButton detailsButton;
    private JButton firstButton;
    private JScrollPane jScrollPaneDetail;
    private JScrollPane jScrollPaneSummary;
    private JButton lastButton;
    private JButton nextButton;
    private JButton previousButton;
    private JTextArea summaryTextArea;
    private JCheckBox showLatestRecordCheBox;

    public LogRecordDisplayPanel() {
        this.initComponents();
        this._currentCard = SUMMARY;
        this.showCard(this._currentCard);
    }

    public void setXmlFormatter(ImprovedXMLFormatter xmlFormatter) {
        this._xmlFormatter = xmlFormatter;
    }

    private void initComponents() {
        Insets textButtonMargin = RmaInsets.insets(4, 4, 4, 4);
        Insets navButtonMargin1 = RmaInsets.insets(4, 2, 4, 2);
        Insets navButtonMargin2 = RmaInsets.insets(4, 6, 4, 6);
        this.detailsButton = new JButton();
        this.detailsButton.setMargin(textButtonMargin);
        this.firstButton = new JButton();
        this.firstButton.setMargin(navButtonMargin1);
        this.previousButton = new JButton();
        this.previousButton.setMargin(navButtonMargin2);
        this.nextButton = new JButton();
        this.nextButton.setMargin(navButtonMargin2);
        this.lastButton = new JButton();
        this.lastButton.setMargin(navButtonMargin1);
        this.currentIdxLabel = new JLabel();
        this.cardPanel = new JPanel();
        this.jScrollPaneSummary = new JScrollPane();
        this.summaryTextArea = new JTextArea();
        this.jScrollPaneDetail = new JScrollPane();
        this.detailTextArea = new JTextArea();
        this.clearButton = new JButton();
        this.clearButton.setMargin(textButtonMargin);
        this.clearAllButton = new JButton();
        this.clearAllButton.setMargin(textButtonMargin);
        this.setMinimumSize(new Dimension(600, 280));
        this.setPreferredSize(new Dimension(600, 280));
        this.setLayout(new GridBagLayout());
        this.detailsButton.setText("Show Details");
        this.detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogRecordDisplayPanel.this.detailsButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.detailsButton, gridBagConstraints);
        this.firstButton.setText("<<");
        this.firstButton.setToolTipText("First Record");
        this.firstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogRecordDisplayPanel.this.firstButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.firstButton, gridBagConstraints);
        this.previousButton.setText("<");
        this.previousButton.setToolTipText("Previous Record");
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogRecordDisplayPanel.this.previousButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.previousButton, gridBagConstraints);
        this.nextButton.setText(">");
        this.nextButton.setToolTipText("Next Record");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogRecordDisplayPanel.this.nextButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.nextButton, gridBagConstraints);
        this.lastButton.setText(">>");
        this.lastButton.setToolTipText("Last Record");
        this.lastButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogRecordDisplayPanel.this.lastButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lastButton, gridBagConstraints);
        this.currentIdxLabel.setText("Record 0 of 0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.currentIdxLabel, gridBagConstraints);
        this.showLatestRecordCheBox = new JCheckBox("Show Latest Record");
        this.showLatestRecordCheBox.setSelected(true);
        GridBagConstraints gbc_chckbxNewCheckBox = new GridBagConstraints();
        gbc_chckbxNewCheckBox.insets = new Insets(5, 5, 5, 5);
        gbc_chckbxNewCheckBox.anchor = 2048;
        gbc_chckbxNewCheckBox.gridx = 8;
        gbc_chckbxNewCheckBox.gridy = 0;
        this.add((Component)this.showLatestRecordCheBox, gbc_chckbxNewCheckBox);
        this.showLatestRecordCheBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean tf = LogRecordDisplayPanel.this.showLatestRecordCheBox.isSelected();
                LogRecordDisplayPanel.this.setDisplayLastRecordOnAdd(tf);
            }
        });
        this.cardPanel.setBackground(new Color(51, 255, 102));
        this.cardPanel.setLayout(new CardLayout());
        this.summaryTextArea.setColumns(20);
        this.summaryTextArea.setEditable(false);
        this.summaryTextArea.setLineWrap(true);
        this.summaryTextArea.setRows(5);
        this.summaryTextArea.setBorder(null);
        this.jScrollPaneSummary.setViewportView(this.summaryTextArea);
        this.cardPanel.add((Component)this.jScrollPaneSummary, SUMMARY);
        this.detailTextArea.setColumns(20);
        this.detailTextArea.setEditable(false);
        this.detailTextArea.setRows(5);
        this.jScrollPaneDetail.setViewportView(this.detailTextArea);
        this.cardPanel.add((Component)this.jScrollPaneDetail, DETAILS);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.cardPanel, gridBagConstraints);
        this.clearButton.setText("Clear");
        this.clearButton.setToolTipText("Clear the Current Record");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogRecordDisplayPanel.this.clearButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.clearButton, gridBagConstraints);
        this.clearAllButton.setText("Clear All");
        this.clearAllButton.setToolTipText("Clear All Records");
        this.clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogRecordDisplayPanel.this.clearAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.clearAllButton, gridBagConstraints);
    }

    private void detailsButtonActionPerformed(ActionEvent evt) {
        if (this._currentCard.equals(SUMMARY)) {
            this.showCard(DETAILS);
        } else {
            this.showCard(SUMMARY);
        }
        this.updateState();
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        --this._currentLogIdx;
        this.updateState();
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        ++this._currentLogIdx;
        this.updateState();
    }

    private void firstButtonActionPerformed(ActionEvent evt) {
        this._currentLogIdx = 0;
        this.updateState();
    }

    private void lastButtonActionPerformed(ActionEvent evt) {
        this._currentLogIdx = this.getLogRecordList().size() - 1;
        if (this._currentLogIdx < 0) {
            this._currentLogIdx = 0;
        }
        this.updateState();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.clearCurrentLogRecord();
    }

    private void clearAllButtonActionPerformed(ActionEvent evt) {
        this.clearAllLogRecords();
    }

    private void showCard(String card) {
        CardLayout cl = (CardLayout)this.cardPanel.getLayout();
        cl.show(this.cardPanel, card);
        this._currentCard = card;
    }

    @Override
    public void setDisplayLastRecordOnAdd(boolean tf) {
        this.showLatestRecordCheBox.setSelected(tf);
    }

    @Override
    public boolean isDisplayLastRecordOnAdd() {
        return this.showLatestRecordCheBox.isSelected();
    }

    @Override
    public void addLogRecord(LogRecord rec) {
        try {
            String string = this._xmlFormatter.format(rec);
            XmlLogRecord xmlLogRecord = new XmlLogRecord(string);
            this.getLogRecordList().add(xmlLogRecord);
            if (this.isDisplayLastRecordOnAdd()) {
                this._currentLogIdx = this.getLogRecordList().size() - 1;
            }
            this.updateState();
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(LogRecordDisplayPanel.class.getName());
            logger.log(Level.FINE, "Error parsing log record", e);
        }
    }

    private void clearCurrentLogRecord() {
        this.getLogRecordList().remove(this._currentLogIdx);
        this.updateState();
    }

    @Override
    public void clearAllLogRecords() {
        this.getLogRecordList().clear();
        this._currentLogIdx = 0;
        this._currentCard = SUMMARY;
        this.updateState();
    }

    public void updateState() {
        boolean noRecords = this.getLogRecordList().isEmpty();
        this.detailsButton.setEnabled(!noRecords);
        this.previousButton.setEnabled(!noRecords);
        this.nextButton.setEnabled(!noRecords);
        this.firstButton.setEnabled(!noRecords);
        this.lastButton.setEnabled(!noRecords);
        if (this._saveAction != null) {
            this._saveAction.setEnabled(!noRecords);
        }
        this.clearButton.setEnabled(!noRecords);
        this.clearAllButton.setEnabled(!noRecords);
        this.summaryTextArea.setText("");
        this.detailTextArea.setText("");
        this.currentIdxLabel.setText("");
        if (noRecords) {
            this.showCard(SUMMARY);
            this.setMessagesForNoErrorCase();
        } else {
            if (this._currentLogIdx < 0) {
                this._currentLogIdx = 0;
            } else if (this._currentLogIdx >= this.getLogRecordList().size()) {
                this._currentLogIdx = this.getLogRecordList().size() - 1;
            }
            this.currentIdxLabel.setText("Record " + (this._currentLogIdx + 1) + " of " + this.getLogRecordList().size());
            XmlLogRecord rec = this.getLogRecordList().get(this._currentLogIdx);
            StringBuilder sbSummary = new StringBuilder();
            StringBuilder sbDetailed = new StringBuilder();
            long millis = rec.getMillis();
            String strDate = this.sdf.format(new Date(millis));
            sbSummary.append(strDate);
            sbSummary.append("\n\n");
            sbDetailed.append(strDate);
            sbDetailed.append("\n");
            sbDetailed.append(rec.getLevel());
            sbDetailed.append("\n");
            String logMessage = rec.getMessage();
            String sourceClassName = rec.getSourceClassName();
            String sourceMethodName = rec.getSourceMethodName();
            List<ThrownMessageStack> thrownList = rec.getThrownMessageStackList();
            if (logMessage != null) {
                sbSummary.append(logMessage);
                sbDetailed.append(logMessage);
                sbDetailed.append("\n\n");
                sbDetailed.append(sourceClassName);
                sbDetailed.append(".");
                sbDetailed.append(sourceMethodName);
                sbDetailed.append("\n");
                for (ThrownMessageStack thrownMessageStack : thrownList) {
                    String thrownMessage = thrownMessageStack.getMessage();
                    String thrownStack = thrownMessageStack.getStack();
                    if (thrownMessage != null) {
                        sbDetailed.append("\n");
                        sbDetailed.append(thrownMessage);
                        sbDetailed.append("\n");
                    }
                    if (thrownStack == null) continue;
                    sbDetailed.append(thrownStack);
                }
            } else {
                sbDetailed.append(sourceClassName);
                sbDetailed.append(".");
                sbDetailed.append(sourceMethodName);
                sbDetailed.append("\n");
                for (ThrownMessageStack thrownMessageStack : thrownList) {
                    String thrownMessage = thrownMessageStack.getMessage();
                    String thrownStack = thrownMessageStack.getStack();
                    if (thrownMessage != null) {
                        sbSummary.append(thrownMessage);
                        sbDetailed.append(thrownMessage);
                        sbDetailed.append("\n\n");
                    }
                    if (thrownStack != null) {
                        sbDetailed.append(thrownStack);
                        continue;
                    }
                    sbSummary.append("An error occurred that did not have an associated message or exception.");
                    sbDetailed.append("An error occurred that did not have an associated message or exception.");
                }
            }
            String strSummary = sbSummary.toString();
            String strDetailed = sbDetailed.toString();
            this.summaryTextArea.setText(strSummary);
            this.detailTextArea.setText(strDetailed);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LogRecordDisplayPanel.this.jScrollPaneSummary.getViewport().setViewPosition(new Point());
                    LogRecordDisplayPanel.this.jScrollPaneDetail.getViewport().setViewPosition(new Point());
                }
            });
            if (this._currentLogIdx == 0) {
                this.previousButton.setEnabled(false);
                this.nextButton.setEnabled(this.getLogRecordList().size() > 1);
                this.firstButton.setEnabled(false);
                this.lastButton.setEnabled(this.getLogRecordList().size() > 1);
            } else if (this._currentLogIdx >= this.getLogRecordList().size() - 1) {
                this.previousButton.setEnabled(this._currentLogIdx > 0);
                this.nextButton.setEnabled(false);
                this.firstButton.setEnabled(this._currentLogIdx > 0);
                this.lastButton.setEnabled(false);
            } else {
                this.previousButton.setEnabled(true);
                this.nextButton.setEnabled(true);
                this.firstButton.setEnabled(true);
                this.lastButton.setEnabled(true);
            }
        }
        if (this._currentCard.equals(SUMMARY)) {
            this.detailsButton.setText("Show Details");
        } else {
            this.detailsButton.setText("Hide Details");
        }
        this.firePropertyChange("STATE_UPDATE", null, this);
    }

    public void setMessagesForNoErrorCase() {
        this.summaryTextArea.setText("No Errors");
        this.detailTextArea.setText("No Errors");
        this.currentIdxLabel.setText("No Records");
    }

    @Override
    public void setVisible(boolean tf) {
        this.updateState();
    }

    @Override
    public List<XmlLogRecord> getLogRecordList() {
        return this._logRecordList;
    }

    @Override
    public int getCurrentRecordIndex() {
        return this._currentLogIdx;
    }

    @Override
    public void setCurrentRecordIndex(int idx) {
        this._currentLogIdx = idx;
        this.updateState();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setLogRecordList(List<XmlLogRecord> logRecordList) {
        this.getLogRecordList().clear();
        this.getLogRecordList().addAll(logRecordList);
        this.updateState();
    }

    @Override
    public void setCurrentRecordSequence(long currentRecordSequence) {
        this._currentLogIdx = 0;
        for (int ii = 0; ii < this.getLogRecordList().size(); ++ii) {
            XmlLogRecord logRecord = this.getLogRecordList().get(ii);
            if (currentRecordSequence != logRecord.getSequenceNumber()) continue;
            this._currentLogIdx = ii;
            break;
        }
        this.updateState();
    }

    @Override
    public long getCurrentRecordSequence() {
        if (this.getLogRecordList().isEmpty()) {
            return -1L;
        }
        XmlLogRecord xmlLogRecord = this.getLogRecordList().get(this._currentLogIdx);
        long sequenceNumber = xmlLogRecord.getSequenceNumber();
        return sequenceNumber;
    }
}

