/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.logging;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import rma.swing.logging.CloseRecordDisplayAction;
import rma.swing.logging.ILogRecordDisplay;
import rma.swing.logging.OpenRecordsFileAction;
import rma.swing.logging.SaveRecordsToFileAction;

public class LogRecordMenuBar
extends JMenuBar {
    private ILogRecordDisplay _logRecordPanel;
    private OpenRecordsFileAction openRecordsAction;
    private SaveRecordsToFileAction saveRecordsAction;
    private CloseRecordDisplayAction closeRecordDisplayAction;

    public LogRecordMenuBar(ILogRecordDisplay logRecordPanel) {
        this._logRecordPanel = logRecordPanel;
        this._logRecordPanel.addPropertyChangeListener("STATE_UPDATE", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LogRecordMenuBar.this.updateState();
            }
        });
    }

    protected void updateState() {
        boolean empty = this._logRecordPanel.getLogRecordList().isEmpty();
        if (this.saveRecordsAction != null) {
            this.saveRecordsAction.setEnabled(!empty);
        }
    }

    public void buildMenu() {
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        this.openRecordsAction = new OpenRecordsFileAction(this._logRecordPanel);
        JMenuItem openMenuItem = menu.add(this.openRecordsAction);
        openMenuItem.setMnemonic('O');
        this.saveRecordsAction = new SaveRecordsToFileAction(this._logRecordPanel);
        JMenuItem saveMenuItem = menu.add(this.saveRecordsAction);
        saveMenuItem.setMnemonic('S');
        this.closeRecordDisplayAction = new CloseRecordDisplayAction(this._logRecordPanel);
        JMenuItem closeMenuItem = menu.add(this.closeRecordDisplayAction);
        this.add(menu);
        this.updateState();
    }
}

