/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.logging;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import org.jdom.Element;
import org.jdom.JDOMException;
import rma.swing.logging.ILogRecordDisplay;
import rma.swing.logging.XmlLogRecord;
import rma.util.RMAIO;
import rma.util.RmaBaseXmlUtilities;

public class OpenRecordsFileAction
extends AbstractAction {
    private ILogRecordDisplay _logRecordPanel;

    public OpenRecordsFileAction(ILogRecordDisplay logRecordPanel) {
        super("Open");
        this._logRecordPanel = logRecordPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.openRecordsFile();
        }
        catch (JDOMException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void openRecordsFile() throws JDOMException, IOException {
        JFileChooser fileChooser = new JFileChooser();
        File dir = null;
        if (dir != null) {
            fileChooser.setCurrentDirectory(dir);
        }
        int showOpenDialog = fileChooser.showOpenDialog(this._logRecordPanel.getComponent());
        File file = null;
        if (showOpenDialog == 0) {
            file = fileChooser.getSelectedFile();
        }
        if (file == null) {
            return;
        }
        FileReader fileReader = new FileReader(file);
        Element rootElement = RmaBaseXmlUtilities.buildElement(fileReader);
        if (rootElement == null) {
            RMAIO.postWarning(this._logRecordPanel.getComponent(), "No log records defined in file");
            return;
        }
        Element currentRecordElement = rootElement.getChild("current-record-sequence");
        long currentRecordSequence = RmaBaseXmlUtilities.getContentAsLong(currentRecordElement, -1L);
        List children = rootElement.getChildren("record");
        ArrayList<XmlLogRecord> logRecordList = new ArrayList<XmlLogRecord>();
        for (int ii = 0; ii < children.size(); ++ii) {
            Element child = (Element)children.get(ii);
            XmlLogRecord xmlLogRecord = new XmlLogRecord(child);
            logRecordList.add(xmlLogRecord);
        }
        this._logRecordPanel.setLogRecordList(logRecordList);
        this._logRecordPanel.setCurrentRecordSequence(currentRecordSequence);
    }
}

