/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.logging;

import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import rma.swing.logging.ILogRecordDisplay;
import rma.swing.logging.XmlLogRecord;
import rma.util.RMAIO;
import rma.util.RmaBaseXmlUtilities;

public class SaveRecordsToFileAction
extends AbstractAction {
    private ILogRecordDisplay _logRecordDisplayInterface;

    public SaveRecordsToFileAction(ILogRecordDisplay logRecordDisplayInterface) {
        super("Save");
        this._logRecordDisplayInterface = logRecordDisplayInterface;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.saveRecordsToFile();
        }
        catch (JDOMException e1) {
            Logger logger = Logger.getLogger(SaveRecordsToFileAction.class.getName());
            logger.log(Level.WARNING, "Error saving records to file", e1);
        }
        catch (IOException e1) {
            Logger logger = Logger.getLogger(SaveRecordsToFileAction.class.getName());
            logger.log(Level.WARNING, "Error saving records to file", e1);
        }
    }

    private void saveRecordsToFile() throws JDOMException, IOException {
        List<XmlLogRecord> logRecordList = this._logRecordDisplayInterface.getLogRecordList();
        Element root = new Element("record-set");
        if (logRecordList.isEmpty()) {
            RMAIO.postWarning(this._logRecordDisplayInterface.getComponent(), "Log record list is empty, no records to save.");
            return;
        }
        long sequenceNumber = this._logRecordDisplayInterface.getCurrentRecordSequence();
        Element sequenceElement = new Element("current-record-sequence");
        sequenceElement.setText(Long.toString(sequenceNumber));
        root.addContent((Content)sequenceElement);
        for (XmlLogRecord logRecord : logRecordList) {
            Element element = RmaBaseXmlUtilities.buildElement(logRecord.toXmlString());
            root.addContent(element.detach());
        }
        Document document = new Document(root);
        Format format = Format.getPrettyFormat();
        String documentXmlString = RmaBaseXmlUtilities.toXmlString(document.getRootElement(), format);
        JFileChooser fileChooser = new JFileChooser();
        File dir = null;
        if (dir != null) {
            fileChooser.setCurrentDirectory(dir);
        }
        fileChooser.showSaveDialog(this._logRecordDisplayInterface.getComponent());
        File selectedFile = fileChooser.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        FileWriter out = new FileWriter(selectedFile);
        BufferedWriter bw = new BufferedWriter(out);
        bw.write(documentXmlString);
        bw.flush();
        out.flush();
        bw.close();
        out.close();
    }
}

