/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class SummaryLogRecordFormatter
extends Formatter {
    private static final DateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");

    @Override
    public String format(LogRecord rec) {
        StringBuilder sbSummary = new StringBuilder();
        long millis = rec.getMillis();
        String strDate = sdf.format(new Date(millis));
        sbSummary.append(strDate);
        sbSummary.append("\n\n");
        String logMessage = rec.getMessage();
        Throwable t = rec.getThrown();
        String sourceClassName = rec.getSourceClassName();
        String sourceMethodName = rec.getSourceMethodName();
        if (logMessage != null) {
            sbSummary.append(logMessage);
        } else if (t != null) {
            String throwableMessage = t.getMessage();
            if (throwableMessage != null) {
                sbSummary.append(throwableMessage);
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.flush();
            sw.flush();
            StringBuffer stack = sw.getBuffer();
            pw.close();
            try {
                sw.close();
            }
            catch (IOException iOException) {}
        } else {
            sbSummary.append("An error occurred that did not have an associated message or exception.");
        }
        return sbSummary.toString();
    }

    @Override
    public String getHead(Handler h) {
        return super.getHead(h);
    }

    @Override
    public String getTail(Handler h) {
        return super.getTail(h);
    }
}

