/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.logging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.JDOMException;
import rma.swing.logging.ThrownMessageStack;
import rma.util.RmaBaseXmlUtilities;

public class XmlLogRecord {
    public static final String FRAME = "frame";
    public static final String EXCEPTION = "exception";
    public static final String METHOD = "method";
    public static final String CLASS = "class";
    public static final String MESSAGE = "message";
    public static final String LEVEL = "level";
    public static final String MILLIS = "millis";
    public static final String SEQUENCE = "sequence";
    public static final String LINE = "line";
    public static final String AT_STRING = "\tat ";
    public static final String withInnerParsingRegexp = ".*\\.(.*)\\$.*";
    public static final Pattern withInnerParsingPattern = Pattern.compile(".*\\.(.*)\\$.*");
    public static final String parsingRegexp = ".*\\.(.*)";
    public static final Pattern parsingPattern = Pattern.compile(".*\\.(.*)");
    public static final String ELEMENT = "record";
    private Element _recordElement;

    public XmlLogRecord(String xmlString) throws JDOMException, IOException {
        this._recordElement = RmaBaseXmlUtilities.buildElement(xmlString);
    }

    public XmlLogRecord(Element elem) throws JDOMException, IOException {
        this._recordElement = RmaBaseXmlUtilities.buildElement(RmaBaseXmlUtilities.toXmlString(elem));
    }

    public String toXmlString() throws IOException {
        return RmaBaseXmlUtilities.toXmlString(this._recordElement);
    }

    public long getSequenceNumber() {
        return RmaBaseXmlUtilities.getChildElementAsLong(this._recordElement, SEQUENCE, -1L);
    }

    public long getMillis() {
        return RmaBaseXmlUtilities.getChildElementAsLong(this._recordElement, MILLIS, 0L);
    }

    public Level getLevel() {
        String levelString = RmaBaseXmlUtilities.getChildElementAsString(this._recordElement, LEVEL, null);
        try {
            Level level = Level.parse(levelString);
            return level;
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(XmlLogRecord.class.getName());
            logger.log(Level.FINE, "Error parsing level", e);
            return null;
        }
    }

    public String getMessage() {
        return RmaBaseXmlUtilities.getChildElementAsString(this._recordElement, MESSAGE, "");
    }

    public void setMessage(String message) {
    }

    public String getSourceClassName() {
        return RmaBaseXmlUtilities.getChildElementAsString(this._recordElement, CLASS, null);
    }

    public String getSourceMethodName() {
        return RmaBaseXmlUtilities.getChildElementAsString(this._recordElement, METHOD, null);
    }

    public List<ThrownMessageStack> getThrownMessageStackList() {
        ArrayList<ThrownMessageStack> retval = new ArrayList<ThrownMessageStack>();
        List exceptionElementChildren = this._recordElement.getChildren(EXCEPTION);
        if (exceptionElementChildren == null || exceptionElementChildren.isEmpty()) {
            return retval;
        }
        for (int ii = 0; ii < exceptionElementChildren.size(); ++ii) {
            Element exceptionElement = (Element)exceptionElementChildren.get(ii);
            String message = RmaBaseXmlUtilities.getChildElementAsString(exceptionElement, MESSAGE, null);
            List frames = exceptionElement.getChildren(FRAME);
            String stack = null;
            if (!frames.isEmpty()) {
                StringBuffer framesSb = new StringBuffer();
                for (int jj = 0; jj < frames.size(); ++jj) {
                    Element frameElement = (Element)frames.get(jj);
                    String strClass = RmaBaseXmlUtilities.getChildElementAsString(frameElement, CLASS, null);
                    String strMethod = RmaBaseXmlUtilities.getChildElementAsString(frameElement, METHOD, null);
                    int line = RmaBaseXmlUtilities.getChildElementAsInt(frameElement, LINE, -1);
                    if (strClass == null || strMethod == null || line == -1) continue;
                    framesSb.append(AT_STRING).append(strClass).append(".").append(strMethod).append("(").append(this.getSimpleClassName(strClass)).append(".java:").append(line).append(")\n");
                }
                stack = framesSb.toString();
            }
            ThrownMessageStack thrownMessageStack = new ThrownMessageStack(message, stack);
            retval.add(thrownMessageStack);
        }
        return retval;
    }

    public String getSimpleClassName(String fullyQualifiedClass) {
        Matcher m = withInnerParsingPattern.matcher(fullyQualifiedClass);
        if (m.matches()) {
            return m.group(1);
        }
        m = parsingPattern.matcher(fullyQualifiedClass);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }
}

