/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.plaf.basic;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import rma.swing.table.AccessTable;

public class AccessTableUI
extends BasicTableUI {
    AccessTable m_table;

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new BasicTableUI.MouseInputHandler(){

            private boolean shouldIgnore(MouseEvent e) {
                return !SwingUtilities.isLeftMouseButton(e) || !AccessTableUI.this.m_table.isEnabled();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int column;
                if (this.shouldIgnore(e)) {
                    return;
                }
                Point p = e.getPoint();
                int row = AccessTableUI.this.m_table.rowAtPoint(p);
                if (!AccessTableUI.this.m_table.moveToNewPosition(row, column = AccessTableUI.this.m_table.columnAtPoint(p))) {
                    return;
                }
                super.mousePressed(e);
            }
        };
    }

    public static ComponentUI createUI(JComponent c2) {
        return new AccessTableUI();
    }

    @Override
    public void installUI(JComponent c2) {
        if (!(c2 instanceof AccessTable)) {
            throw new Error("AccessTable needs rma.awt.table.AccessTable");
        }
        this.m_table = (AccessTable)c2;
        super.installUI(c2);
    }
}

