/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import rma.swing.DateChooserField;

public class BasicDateFieldUI
extends BasicTextFieldUI {
    JButton _ellipsesButton;
    DateChooserField _dateField;
    MouseAdapter _mouseListener;
    ActionListener _actionListener;
    MouseMotionAdapter _mouseMotionListener;
    protected Dimension cachedMinimumSize = new Dimension(0, 0);

    public static ComponentUI createUI(JComponent c2) {
        return new BasicDateFieldUI();
    }

    public BasicDateFieldUI() {
        this._mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!((JComponent)((Object)BasicDateFieldUI.this._dateField)).isEnabled()) {
                    return;
                }
                if (!BasicDateFieldUI.this._dateField.isCalenderToolEnabled()) {
                    return;
                }
                Point p = e.getPoint();
                if (p.x > ((JComponent)((Object)BasicDateFieldUI.this._dateField)).getWidth() - BasicDateFieldUI.this._ellipsesButton.getWidth()) {
                    BasicDateFieldUI.this._ellipsesButton.doClick();
                }
            }
        };
        this._mouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int x = e.getPoint().x;
                JComponent comp = (JComponent)((Object)BasicDateFieldUI.this._dateField);
                if (x > comp.getWidth() - BasicDateFieldUI.this._ellipsesButton.getWidth()) {
                    comp.setCursor(Cursor.getPredefinedCursor(0));
                } else {
                    comp.setCursor(Cursor.getPredefinedCursor(2));
                }
            }
        };
        this._actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BasicDateFieldUI.this._dateField.isCalenderToolEnabled()) {
                    BasicDateFieldUI.this._dateField.displayChooserDialog();
                }
            }
        };
    }

    @Override
    protected String getPropertyPrefix() {
        return "TextField";
    }

    @Override
    public void installUI(JComponent c2) {
        if (!(c2 instanceof DateChooserField)) {
            String classname = "null";
            if (null != c2) {
                classname = c2.getClass().getName();
            }
            throw new Error("BasicDateFieldUI needs rma.swing.DateChooserField was:" + classname);
        }
        this._dateField = (DateChooserField)((Object)c2);
        super.installUI(c2);
        if (this._ellipsesButton != null) {
            this.configureEllipsesButton();
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this._ellipsesButton = this.createEllipsesButton();
        JComponent comp = (JComponent)((Object)this._dateField);
        comp.add(this._ellipsesButton);
        comp.setLayout(this.createLayoutManager());
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle alloc = new Rectangle(((JComponent)((Object)this._dateField)).getSize());
        Insets insets = ((JComponent)((Object)this._dateField)).getInsets();
        alloc.x += insets.left;
        alloc.y += insets.top;
        alloc.width -= insets.left + insets.right;
        if (this._dateField.isCalenderToolEnabled()) {
            alloc.width -= this._ellipsesButton.getBounds().width;
        }
        alloc.height -= insets.top + insets.bottom;
        return alloc;
    }

    @Override
    protected void paintSafely(Graphics g) {
        super.paintSafely(g);
        if (this._ellipsesButton != null && this._dateField.isCalenderToolEnabled()) {
            Rectangle r = this._ellipsesButton.getBounds();
            Rectangle a = this.getVisibleEditorRect();
            g.translate(r.x, r.y);
            this._ellipsesButton.paint(g);
        }
    }

    protected JButton createEllipsesButton() {
        return new JButton("..."){

            @Override
            public void paint(Graphics g) {
                if (BasicDateFieldUI.this._dateField.isCalenderToolEnabled()) {
                    super.paint(g);
                }
            }
        };
    }

    public void configureEllipsesButton() {
        if (this._ellipsesButton != null) {
            this._ellipsesButton.setEnabled(((JComponent)((Object)this._dateField)).isEnabled());
            this._ellipsesButton.setRequestFocusEnabled(false);
            this._ellipsesButton.setFocusable(false);
            this._ellipsesButton.setCursor(Cursor.getPredefinedCursor(0));
            if (this._mouseListener != null) {
                this._ellipsesButton.addActionListener(this._actionListener);
                ((JComponent)((Object)this._dateField)).addMouseListener(this._mouseListener);
                ((JComponent)((Object)this._dateField)).addMouseMotionListener(this._mouseMotionListener);
            }
        }
    }

    protected LayoutManager createLayoutManager() {
        return new DateFieldLayoutManager();
    }

    protected Insets getInsets() {
        return ((JComponent)((Object)this._dateField)).getInsets();
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Dimension size = this.getMinimumSize(c2);
        size.width += 4;
        return size;
    }

    @Override
    public Dimension getMinimumSize(JComponent c2) {
        Insets insets = this.getInsets();
        JComponent comp = (JComponent)((Object)this._dateField);
        FontMetrics fm = comp.getFontMetrics(comp.getFont());
        Dimension size = new Dimension(60, fm.getHeight());
        size.height += insets.top + insets.bottom;
        int buttonSize = size.height - (insets.top + insets.bottom);
        size.width += insets.left + insets.right + buttonSize;
        this.cachedMinimumSize.setSize(size.width, size.height);
        return size;
    }

    @Override
    public Dimension getMaximumSize(JComponent c2) {
        Dimension size = this.getPreferredSize(c2);
        size.width = Short.MAX_VALUE;
        return size;
    }

    public class DateFieldLayoutManager
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            JComponent cb = (JComponent)parent;
            return parent.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            JComponent cb = (JComponent)parent;
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            JComponent df = (JComponent)parent;
            int width = df.getWidth();
            int height = df.getHeight();
            Insets insets = BasicDateFieldUI.this.getInsets();
            int buttonSize = height - (insets.top + insets.bottom);
            if (BasicDateFieldUI.this._ellipsesButton != null) {
                if (BasicDateFieldUI.this._dateField.isCalenderToolEnabled()) {
                    BasicDateFieldUI.this._ellipsesButton.setBounds(width - (insets.right + buttonSize), insets.top, buttonSize, buttonSize);
                } else {
                    BasicDateFieldUI.this._ellipsesButton.setBounds(width - (insets.right + buttonSize), insets.top, 0, 0);
                }
            }
        }
    }
}

