/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import rma.swing.RmaJDescriptionField;

public class BasicDescFieldUI
extends BasicTextAreaUI {
    JButton _ellipsesButton;
    RmaJDescriptionField _descField;
    MouseAdapter _mouseListener;
    ActionListener _actionListener;
    MouseMotionAdapter _mouseMotionListener;
    protected Dimension cachedMinimumSize = new Dimension(0, 0);

    public static ComponentUI createUI(JComponent c2) {
        return new BasicDescFieldUI();
    }

    public BasicDescFieldUI() {
        this._mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point p = e.getPoint();
                if (p.x > BasicDescFieldUI.this._descField.getWidth() - BasicDescFieldUI.this._ellipsesButton.getWidth()) {
                    BasicDescFieldUI.this._ellipsesButton.doClick();
                }
            }
        };
        this._mouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int x = e.getPoint().x;
                if (x > BasicDescFieldUI.this._descField.getWidth() - BasicDescFieldUI.this._ellipsesButton.getWidth()) {
                    BasicDescFieldUI.this._descField.setCursor(Cursor.getPredefinedCursor(0));
                } else {
                    BasicDescFieldUI.this._descField.setCursor(Cursor.getPredefinedCursor(2));
                }
            }
        };
        this._actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicDescFieldUI.this._descField.displayChooserDialog();
            }
        };
    }

    @Override
    protected String getPropertyPrefix() {
        return "TextField";
    }

    @Override
    public void installUI(JComponent c2) {
        if (!(c2 instanceof RmaJDescriptionField)) {
            String classname = "null";
            if (null != c2) {
                classname = c2.getClass().getName();
            }
            throw new Error("BasicDescFieldUI needs rma.swing.RmaJDescriptionField was:" + classname);
        }
        this._descField = (RmaJDescriptionField)c2;
        super.installUI(c2);
        if (this._ellipsesButton != null) {
            this.configureEllipsesButton();
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this._ellipsesButton = this.createEllipsesButton();
        this._descField.add(this._ellipsesButton);
        this._descField.setLayout(this.createLayoutManager());
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle alloc = new Rectangle(this._descField.getSize());
        Insets insets = this._descField.getInsets();
        alloc.x += insets.left;
        alloc.y += insets.top;
        alloc.width -= insets.left + insets.right;
        alloc.width -= this._ellipsesButton.getBounds().width;
        alloc.height -= insets.top + insets.bottom;
        return alloc;
    }

    @Override
    protected void paintSafely(Graphics g) {
        super.paintSafely(g);
        if (this._ellipsesButton != null) {
            Rectangle r = this._ellipsesButton.getBounds();
            Rectangle a = this.getVisibleEditorRect();
            g.translate(r.x, r.y);
            this._ellipsesButton.paint(g);
        }
    }

    protected JButton createEllipsesButton() {
        return new JButton("...");
    }

    public void configureEllipsesButton() {
        if (this._ellipsesButton != null) {
            this._ellipsesButton.setEnabled(this._descField.isEnabled());
            this._ellipsesButton.setRequestFocusEnabled(false);
            this._ellipsesButton.setCursor(Cursor.getPredefinedCursor(0));
            if (this._mouseListener != null) {
                this._ellipsesButton.addActionListener(this._actionListener);
                this._descField.addMouseListener(this._mouseListener);
                this._descField.addMouseMotionListener(this._mouseMotionListener);
            }
        }
    }

    protected LayoutManager createLayoutManager() {
        return new DateFieldLayoutManager();
    }

    protected Insets getInsets() {
        return this._descField.getInsets();
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Dimension size = this.getMinimumSize(c2);
        size.width += 4;
        return size;
    }

    @Override
    public Dimension getMinimumSize(JComponent c2) {
        Insets insets = this.getInsets();
        FontMetrics fm = this._descField.getFontMetrics(this._descField.getFont());
        Dimension size = new Dimension(100, fm.getHeight());
        size.height += insets.top + insets.bottom;
        int buttonSize = size.height - (insets.top + insets.bottom);
        size.width += insets.left + insets.right + buttonSize;
        this.cachedMinimumSize.setSize(size.width, size.height);
        return size;
    }

    @Override
    public Dimension getMaximumSize(JComponent c2) {
        Dimension size = this.getPreferredSize(c2);
        size.width = Short.MAX_VALUE;
        return size;
    }

    public class DateFieldLayoutManager
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            RmaJDescriptionField cb = (RmaJDescriptionField)parent;
            return parent.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            RmaJDescriptionField cb = (RmaJDescriptionField)parent;
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            RmaJDescriptionField df = (RmaJDescriptionField)parent;
            int width = df.getWidth();
            int height = df.getHeight();
            Insets insets = BasicDescFieldUI.this.getInsets();
            int buttonSize = height - (insets.top + insets.bottom);
            if (BasicDescFieldUI.this._ellipsesButton != null) {
                BasicDescFieldUI.this._ellipsesButton.setBounds(width - (insets.right + buttonSize), insets.top, buttonSize, buttonSize);
            }
        }
    }
}

