/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class BooleanRenderer
extends JCheckBox
implements TableCellRenderer {
    private boolean _useSelectionBackground;

    public BooleanRenderer(boolean useSelectionBackground) {
        this._useSelectionBackground = useSelectionBackground;
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table.isCellEditable(row, column)) {
            this.setEnabled(true);
            this.setBackground(table.getBackground());
        } else {
            this.setEnabled(false);
            this.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        }
        this.setForeground(table.getForeground());
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            if (this._useSelectionBackground) {
                super.setBackground(table.getSelectionBackground());
            }
        }
        this.setSelected(value != null && "true".equalsIgnoreCase(value.toString()));
        return this;
    }
}

