/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.util.ArrayList;
import java.util.List;
import rma.swing.table.CellLocation;

final class CellSelectionSet {
    private final List<CellLocation> _cells = new ArrayList<CellLocation>();

    CellSelectionSet() {
    }

    public void add(int r, int c2) {
        if (!this.contains(r, c2)) {
            this._cells.add(new CellLocation(r, c2, null));
        }
    }

    public void remove(int r, int c2) {
        this._cells.remove(new CellLocation(r, c2, null));
    }

    public CellLocation getCellAt(int row, int col) {
        return this._cells.stream().filter(cell -> cell.equals(row, col)).findFirst().orElse(null);
    }

    public List<CellLocation> getCells() {
        return this._cells;
    }

    public boolean containsOneOrLess() {
        return this._cells.size() <= 1;
    }

    public boolean contains(int r, int c2) {
        for (CellLocation cell : this._cells) {
            if (!cell.equals(r, c2)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this._cells.clear();
    }
}

