/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ColumnGroup {
    protected TableCellRenderer _renderer;
    protected Vector v;
    protected String _text;
    protected int margin = 0;
    protected Color _background = null;
    protected Color _foreground = null;

    public ColumnGroup(String text) {
        this(null, text);
    }

    public ColumnGroup(TableCellRenderer renderer, String text) {
        this._renderer = renderer == null ? new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    this.setForeground(ColumnGroup.this._foreground == null ? header.getForeground() : ColumnGroup.this._foreground);
                    this.setBackground(ColumnGroup.this._background == null ? header.getBackground() : ColumnGroup.this._background);
                    this.setFont(header.getFont());
                }
                this.setHorizontalAlignment(0);
                this.setText(value == null ? "" : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        } : renderer;
        this._text = text;
        this.v = new Vector();
    }

    public void add(Object obj) {
        if (obj == null) {
            return;
        }
        this.v.addElement(obj);
    }

    public void insert(int col, Object obj) {
        if (obj == null || col < 0) {
            return;
        }
        this.v.insertElementAt(obj, col);
    }

    public boolean remove(Object obj) {
        return this.v.remove(obj);
    }

    public void clear() {
        this.v.clear();
    }

    public Vector getColumnGroups(Object c2, Vector g) {
        g.addElement(this);
        if (this.v.contains(c2)) {
            return g;
        }
        int size = this.v.size();
        for (int i = 0; i < size; ++i) {
            Vector groups;
            Object obj = this.v.get(i);
            if (!(obj instanceof ColumnGroup) || (groups = ((ColumnGroup)obj).getColumnGroups(c2, (Vector)g.clone())) == null) continue;
            return groups;
        }
        return null;
    }

    public Vector getTableColumns() {
        int size = this.v.size();
        Vector tc = new Vector(this.v.size());
        for (int i = 0; i < size; ++i) {
            Object obj = this.v.get(i);
            if (!(obj instanceof TableColumn)) continue;
            tc.add(obj);
        }
        return tc;
    }

    public List getColumnGroups() {
        int size = this.v.size();
        ArrayList cg = new ArrayList(this.v.size());
        for (int i = 0; i < size; ++i) {
            Object obj = this.v.get(i);
            if (!(obj instanceof ColumnGroup)) continue;
            cg.add(obj);
        }
        return cg;
    }

    public TableCellRenderer getHeaderRenderer() {
        return this._renderer;
    }

    public void setHeaderRenderer(TableCellRenderer renderer) {
        if (renderer != null) {
            this._renderer = renderer;
        }
    }

    public Object getHeaderValue() {
        return this._text;
    }

    public void setHeaderValue(Object obj) {
        this._text = obj != null ? obj.toString() : "";
    }

    public void setBackground(Color bg) {
        this._background = bg;
    }

    public Color getBackground() {
        return this._background;
    }

    public void setForeground(Color fg) {
        this._foreground = fg;
    }

    public Color getForeground() {
        return this._foreground;
    }

    public Dimension getSize(JTable table, int column) {
        Component comp = this._renderer.getTableCellRendererComponent(table, this.getHeaderValue(), false, false, -1, column);
        int height = comp.getPreferredSize().height;
        int width = 0;
        Enumeration enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj instanceof TableColumn) {
                TableColumn aColumn = (TableColumn)obj;
                width += aColumn.getWidth();
                continue;
            }
            width += ((ColumnGroup)obj).getSize((JTable)table, (int)column).width;
        }
        return new Dimension(width, height);
    }

    public void setColumnMargin(int margin) {
        this.margin = margin;
        Enumeration enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof ColumnGroup)) continue;
            ((ColumnGroup)obj).setColumnMargin(margin);
        }
    }
}

