/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.table.TableCellRenderer;
import rma.swing.RmaJTable;
import rma.swing.table.RmaCellRenderer;

public class ComboBoxRenderer
extends RmaCellRenderer
implements TableCellRenderer {
    private DefaultComboBoxModel m_comboBoxModel = new DefaultComboBoxModel();
    private ListCellRenderer m_comboBoxListRenderer = new ListCellRenderer();
    protected JComboBox m_comboBox = new JComboBox(this.m_comboBoxModel);
    static Border noFocusBorder = new EmptyBorder(0, 0, 0, 0);

    public ComboBoxRenderer() {
        this.m_comboBox.setRenderer(this.m_comboBoxListRenderer);
        this.m_comboBox.setBorder(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.m_comboBoxModel.removeAllElements();
        Component c2 = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.m_comboBoxListRenderer.setRendererForeground(c2.getForeground());
        this.m_comboBoxListRenderer.setRendererBackground(c2.getBackground());
        this.m_comboBox.setBackground(c2.getBackground());
        if (value == null) {
            this.m_comboBoxModel.addElement("");
        } else {
            this.m_comboBoxModel.addElement(value);
        }
        if (c2 != null) {
            if (isSelected && hasFocus) {
                this.m_comboBox.setBorder(((JComponent)c2).getBorder());
            } else {
                this.m_comboBox.setBorder(null);
            }
        }
        this.m_comboBox.setEnabled(table.isCellEditable(row, column));
        return this.m_comboBox;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new GridBagLayout());
        RmaJTable table1 = new RmaJTable((Component)frame, (Object[])new String[]{"1", "2", "3"});
        table1.setNumColumns(3);
        table1.setComboBoxEditor(0, new String[]{"0", "1", "2", "3"});
        table1.setComboBoxEditor(1, new String[]{"0", "1", "2", "3"});
        table1.setComboBoxEditor(2, new String[]{"0", "1", "2", "3"});
        table1.setCellEnabled(false, 0, 0);
        frame.getContentPane().add((Component)table1.getScrollPane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        frame.setLocation(150, 150);
        frame.setSize(250, 250);
        frame.setVisible(true);
    }

    private static class ListCellRenderer
    extends DefaultListCellRenderer {
        Color m_foreground = Color.black;
        Color m_background = Color.white;

        private ListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int modelIndex, boolean isSelected, boolean cellHasFocus) {
            Component c2 = super.getListCellRendererComponent((JList<?>)list, value, modelIndex, isSelected, cellHasFocus);
            if (modelIndex == -1) {
                c2.setForeground(this.m_foreground);
                c2.setBackground(this.m_background);
            }
            return c2;
        }

        public void setRendererForeground(Color fg) {
            this.m_foreground = fg;
        }

        public void setRendererBackground(Color bg) {
            this.m_background = bg;
        }
    }

    public static class TableComboBoxUI
    extends BasicComboBoxUI {
        @Override
        public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
            javax.swing.ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
            if (this.comboBox.getSelectedIndex() == -1) {
                return;
            }
            Component c2 = hasFocus && !this.isPopupVisible(this.comboBox) ? renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false) : renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            this.currentValuePane.paintComponent(g, c2, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height);
        }

        @Override
        protected JButton createArrowButton() {
            return super.createArrowButton();
        }
    }
}

