/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import rma.swing.table.RmaCellRenderer;

public class DecimalCellRenderer
extends RmaCellRenderer {
    boolean _allowDefaultFont = false;
    int _align;
    DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance();
    boolean _showMaximumFractionDigitsForZero = true;

    public DecimalCellRenderer(int precision) {
        this.df.setDecimalSeparatorAlwaysShown(true);
        this.df.setGroupingUsed(true);
        this.setIgnoreParameterRounding(true);
        this.setPrecision(precision);
    }

    public void showMaximumFractionDigitsForZero(boolean tf) {
        this._showMaximumFractionDigitsForZero = tf;
    }

    public void setDecimalFormat(DecimalFormat df) {
        this.df = df;
    }

    public DecimalFormat getDecimalFormat() {
        return this.df;
    }

    public void setPrecision(int precision) {
        this.df.setMaximumFractionDigits(precision);
        this.df.setMinimumFractionDigits(precision);
        if (precision == 0) {
            this.df.setDecimalSeparatorAlwaysShown(false);
        }
    }

    public void setAllowDefaultFont(boolean state) {
        this._allowDefaultFont = state;
    }

    public boolean getAllowDefaultFont() {
        return this._allowDefaultFont;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!this._allowDefaultFont) {
            Font f = label.getFont();
            label.setFont(new Font("monospaced", 0, f.getSize()));
        }
        label.setHorizontalAlignment(4);
        double d = 0.0;
        boolean gotValue = false;
        try {
            d = Double.valueOf(label.getText());
            gotValue = true;
        }
        catch (NumberFormatException nfe) {
            gotValue = false;
        }
        if (gotValue) {
            if (d == 0.0) {
                StringBuffer strBuf = new StringBuffer();
                strBuf.append('0');
                int precision = this.df.getMaximumFractionDigits();
                if (!this._showMaximumFractionDigitsForZero) {
                    precision = this.df.getMinimumFractionDigits();
                }
                if (precision > 0) {
                    strBuf.append('.');
                    for (int i = 0; i < precision; ++i) {
                        strBuf.append('0');
                    }
                }
                label.setText(strBuf.toString());
            } else {
                String s = this.df.format(d);
                label.setText(s);
            }
        }
        return label;
    }
}

