/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import rma.swing.FormManagementListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTable;
import rma.swing.table.AbstractRmaTableModel;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.swing.table.WildcardRowFilter;
import rma.util.IntArray;
import rma.util.WildCardFileFilter;

public class FilterTablePanel
extends JPanel
implements FormManagementListener {
    private FilterTable _filterTable;
    private RmaJTable _dataTable;
    private TableModelListener _tableListener;
    private IntArray _booleanCols = new IntArray();
    private PropertyChangeListener _colWidthListener;
    private List<JComboBox> _cbList = new ArrayList<JComboBox>();
    private TableRowSorter<TableModel> _sorter;
    private ComponentListener _componentListener;
    protected boolean _updatingColumns;

    public FilterTablePanel() {
        super(new GridBagLayout());
        this.buildControls(null);
    }

    public FilterTablePanel(String[] headers) {
        super(new GridBagLayout());
        this.buildControls(headers);
    }

    protected void buildControls(String[] headers) {
        this._filterTable = headers == null ? new FilterTable(this) : new FilterTable(this, headers);
        Vector<String> v = new Vector<String>(1);
        v.add("");
        for (int i = 1; i < this._filterTable.getColumnCount(); ++i) {
            this._filterTable.setComboBoxEditor(i, v);
        }
        this._filterTable.getScrollPane().setVerticalScrollBarPolicy(22);
        this._filterTable.getScrollPane().setHorizontalScrollBarPolicy(31);
        this._filterTable.setMlHeaderRenderer();
        this._filterTable.setRowHeight(this._filterTable.getRowHeight() + 5);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        JScrollPane sp = new JScrollPane(this._filterTable){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = new Dimension(FilterTablePanel.this._dataTable.getScrollPane().getColumnHeader().getPreferredSize());
                d.height += FilterTablePanel.this._filterTable.getPreferredScrollableViewportSize().height;
                return d;
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.add((Component)sp, gbc);
        sp.setHorizontalScrollBarPolicy(31);
        this._tableListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                FilterTablePanel.this.tableHasChanged(e);
            }
        };
        this._dataTable = headers == null ? new DataTable(this) : new DataTable(this, headers);
        this._dataTable.setCheckBoxCellEditor(0);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS0505;
        this.add((Component)this._dataTable.getScrollPane(), gbc);
        this._dataTable.getScrollPane().setVerticalScrollBarPolicy(22);
        this.resetFilterSelections();
        this.addListeners();
    }

    protected void addListeners() {
        this._componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FilterTablePanel.this.updateColumnWidths();
            }
        };
        this._colWidthListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FilterTablePanel.this.updateColumnWidths();
            }
        };
        this._filterTable.getTableHeader().addComponentListener(this._componentListener);
        this._filterTable.addComponentListener(this._componentListener);
        this.addComponentListener(this._componentListener);
        PropertyChangeListener modelPcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableModel newModel;
                if (FilterTablePanel.this._updatingColumns) {
                    return;
                }
                TableModel oldModel = (TableModel)evt.getOldValue();
                if (oldModel != null) {
                    oldModel.removeTableModelListener(FilterTablePanel.this._tableListener);
                }
                if ((newModel = (TableModel)evt.getNewValue()) != null) {
                    newModel.addTableModelListener(FilterTablePanel.this._tableListener);
                }
                FilterTablePanel.this.resetFilterSelections();
                TableColumnModel cm = FilterTablePanel.this._filterTable.getColumnModel();
                for (int i = 0; i < cm.getColumnCount(); ++i) {
                    TableColumn tc = cm.getColumn(i);
                    tc.addPropertyChangeListener(FilterTablePanel.this._colWidthListener);
                }
            }
        };
        this._dataTable.addPropertyChangeListener("model", modelPcl);
        this._dataTable.getModel().addTableModelListener(this._tableListener);
        this._filterTable.setColumnWidths();
    }

    protected void appendRow(Vector rowData) {
        this._dataTable.appendRow(rowData);
        this.resetFilterSelections();
    }

    public void resetFilterSelections() {
        this._filterTable.commitEdit(false);
        this._filterTable.clearCells();
        this._cbList.clear();
        for (int i = 0; i < this._filterTable.getColumnCount(); ++i) {
            if (this._booleanCols.contains(i)) continue;
            this.updateColumnFilterSelection(i);
        }
    }

    protected void updateColumnFilterSelection(int col) {
        if (col == 0) {
            return;
        }
        if (this._dataTable == null) {
            return;
        }
        if (col >= this._dataTable.getColumnCount()) {
            return;
        }
        int rows = this._dataTable.getRowCount();
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < rows; ++i) {
            Object obj = this._dataTable.getValueAt(i, col);
            if (obj == null || v.contains(obj)) continue;
            v.add(obj);
        }
        Collections.sort(v);
        if (!v.contains("")) {
            v.add(0, "");
        }
        JComboBox cb = this._filterTable.setComboBoxEditor(col, v);
        cb.addActionListener(new ComboBoxActionListener(col, cb));
        cb.setEditable(true);
        this._cbList.add(cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateColumnWidths() {
        this._updatingColumns = true;
        try {
            TableColumnModel sumtcm = this._filterTable.getColumnModel();
            TableColumnModel dataTcm = this._dataTable.getColumnModel();
            for (int i = 0; i < dataTcm.getColumnCount(); ++i) {
                dataTcm.getColumn(i).setMinWidth(0);
            }
            TableColumnModel filterTcm = this._filterTable.getColumnModel();
            int dataNumCols = dataTcm.getColumnCount();
            for (int i = 0; i < filterTcm.getColumnCount(); ++i) {
                int width = filterTcm.getColumn(i).getWidth();
                if (i >= dataNumCols) continue;
                dataTcm.getColumn(i).setWidth(width);
                dataTcm.getColumn(i).setPreferredWidth(width);
                dataTcm.getColumn(i).setMaxWidth(width);
                dataTcm.getColumn(i).setMinWidth(width);
            }
        }
        finally {
            EventQueue.invokeLater(() -> {
                this._updatingColumns = false;
            });
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._dataTable.getScrollPane().getColumnHeader().setVisible(false);
    }

    protected void tableHasChanged(TableModelEvent e) {
        int col = e.getColumn();
        if (col == 0) {
            return;
        }
        if (col == -1) {
            this.resetFilterSelections();
        } else {
            this.updateColumnFilterSelection(e.getColumn());
        }
    }

    @Override
    public void clearPerformed() {
        if (this._dataTable != null) {
            this._dataTable.setRowSorter(null);
            this._dataTable.clearPerformed();
            this._dataTable.setRowSorter(this._sorter);
        }
    }

    public void deleteCells() {
        if (this._dataTable != null) {
            this._dataTable.deleteCells();
        }
    }

    public void setModel(RmaTableModelInterface tableModel) {
        int cnt = tableModel.getColumnCount();
        String[] headers = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            headers[i] = tableModel.getColumnName(i);
        }
        this._filterTable.setModel(new RmaTableModel(headers, 1, new boolean[headers.length], null));
        this._filterTable.setMlHeaderRenderer();
        this._dataTable.setModel(tableModel);
        this._sorter = new TableRowSorter<TableModel>(this._dataTable.getModel());
        this._dataTable.setRowSorter(this._sorter);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FilterTablePanel.this._filterTable.setColumnWidths();
            }
        });
    }

    public void setAddRemoveEnabled(boolean b) {
        this._dataTable.setAddRemoveEnabled(b);
    }

    public RmaJIntegerField setIntegerCellEditor(int col) {
        return this._dataTable.setIntegerCellEditor(col);
    }

    public void setNumRows(int rows) {
        this._dataTable.setNumRows(rows);
    }

    public JCheckBox setCheckBoxCellEditor(int col) {
        JCheckBox cb = this._dataTable.setCheckBoxCellEditor(col);
        this._booleanCols.add(col);
        this.resetFilterSelections();
        return cb;
    }

    public JComboBox setComboBoxEditor(int col, Object[] data, boolean sortData) {
        JComboBox cb = this._dataTable.setComboBoxEditor(col, data, sortData);
        this.resetFilterSelections();
        return cb;
    }

    public void setColumnWidths(int[] colWidths) {
        this._filterTable.setColumnWidths(colWidths);
    }

    public void setHorizontalAlignment(int align, int col) {
        if (col >= this._filterTable.getColumnModel().getColumnCount()) {
            return;
        }
        this._filterTable.setHorizontalAlignment(align, col);
        if (col >= this._dataTable.getColumnModel().getColumnCount()) {
            return;
        }
        this._dataTable.setHorizontalAlignment(align, col);
    }

    public int getRowCount() {
        return this._dataTable.getRowCount();
    }

    public Object getValueAt(int row, int col) {
        return this._dataTable.getValueAt(row, col);
    }

    public void setValueAt(Object obj, int row, int col) {
        this._dataTable.setValueAt(obj, row, col);
    }

    public boolean commitEdit(boolean commit) {
        return this._dataTable.commitEdit(commit);
    }

    public JTable getFilterTable() {
        return this._filterTable;
    }

    public JTable getDataTable() {
        return this._dataTable;
    }

    public void deleteRow() {
        this._dataTable.deleteRow();
    }

    public void insertRow() {
        this._dataTable.insertRow();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        FilterTablePanel table = new FilterTablePanel(new String[]{"a", "b", "c", "d"});
        table.deleteCells();
        Vector<String> row = new Vector<String>();
        row.add("1");
        row.add("ab");
        row.add("bb");
        row.add("cc");
        row.add("dd");
        table.appendRow(row);
        row = new Vector();
        row.add("2");
        row.add("ab");
        row.add("eb");
        row.add("fc");
        row.add("gg");
        table.appendRow(row);
        row = new Vector();
        row.add("3");
        row.add("hb");
        row.add("bc");
        row.add("ic");
        row.add("dg");
        table.appendRow(row);
        frame.getContentPane().add(table);
        frame.setSize(300, 300);
        frame.setVisible(true);
    }

    public void updateTableWidth() {
        this._filterTable.setColumnWidths();
    }

    private class FilterTable
    extends RmaJTable {
        public FilterTable(Component parent) {
            super(parent);
        }

        public FilterTable(Component parent, String[] headers) {
            super(parent, (Object[])headers);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension d = super.getPreferredScrollableViewportSize();
            d.height = this.getRowHeight();
            return d;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getPreferredScrollableViewportSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredScrollableViewportSize();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return !FilterTablePanel.this._booleanCols.contains(col);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredScrollableViewportSize();
        }

        @Override
        public Dimension getSize() {
            return this.getPreferredScrollableViewportSize();
        }

        @Override
        public int getWidth() {
            return FilterTablePanel.this._dataTable.getWidth();
        }

        @Override
        public int getHeight() {
            return this.getRowHeight() + 1;
        }

        @Override
        public JScrollPane createScrollPane() {
            JScrollPane sp = new JScrollPane();
            sp.getViewport().setMinimumSize(this.getPreferredScrollableViewportSize());
            sp.getViewport().setMaximumSize(this.getPreferredScrollableViewportSize());
            sp.getViewport().setPreferredSize(this.getPreferredScrollableViewportSize());
            return sp;
        }

        @Override
        public void clearPerformed() {
            this.commitEdit(true);
        }

        public void setColumnWidths() {
            int width;
            TableColumn tc;
            TableColumnModel tcm = this.getColumnModel();
            Font f = this.getTableHeader().getFont();
            FontMetrics fm = this.getTableHeader().getFontMetrics(f);
            double totalWidth = 0.0;
            for (int i = 0; i < tcm.getColumnCount(); ++i) {
                tc = tcm.getColumn(i);
                Object headerValue = tc.getHeaderValue();
                if (headerValue == null) {
                    headerValue = " ";
                }
                String headerTxt = headerValue.toString();
                StringTokenizer tokenizer = new StringTokenizer(headerTxt, "\n");
                width = 0;
                while (tokenizer.hasMoreTokens()) {
                    int tmp = fm.stringWidth(tokenizer.nextToken());
                    width = Math.max(tmp, width);
                }
                tc.setWidth(width);
                tc.setMinWidth(width);
                totalWidth += (double)width;
            }
            if (totalWidth < (double)this.getWidth()) {
                double factor = (double)this.getWidth() / totalWidth;
                for (int i = 0; i < tcm.getColumnCount(); ++i) {
                    tc = tcm.getColumn(i);
                    width = tc.getWidth();
                    width = (int)((double)width * factor);
                    tc.setWidth(width);
                }
            }
            FilterTablePanel.this.updateColumnWidths();
        }
    }

    private class DataTable
    extends RmaJTable {
        public DataTable(Component parent) {
            super(parent);
        }

        public DataTable(Component parent, String[] headers) {
            super(parent, (Object[])headers);
        }

        @Override
        public void clearPerformed() {
            this.commitEdit(true);
            Vector v = ((RmaTableModelInterface)this.getModel()).getDataVector();
            if (v != null) {
                v.clear();
            }
            ((AbstractTableModel)this.getModel()).fireTableDataChanged();
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            super.tableChanged(e);
            this.revalidate();
            this.repaint();
        }
    }

    private class ComboBoxActionListener
    implements ActionListener {
        private int _col;
        private JComboBox _combo;

        public ComboBoxActionListener(int col, JComboBox cb) {
            this._col = col;
            this._combo = cb;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterTablePanel.this._filterTable.commitEdit(true);
            Object filter = this._combo.getSelectedItem();
            int colCnt = FilterTablePanel.this._filterTable.getColumnCount();
            ArrayList<WildcardRowFilter> filters = new ArrayList<WildcardRowFilter>();
            for (int c2 = 0; c2 < colCnt; ++c2) {
                String filterTxt = (String)FilterTablePanel.this._filterTable.getValueAt(0, c2);
                if (filterTxt == null || filterTxt.length() == 0) continue;
                filters.add(new WildcardRowFilter(filterTxt, c2));
            }
            if (filters.size() > 1) {
                FilterTablePanel.this._sorter.setRowFilter(RowFilter.andFilter(filters));
            } else if (filters.size() == 1) {
                FilterTablePanel.this._sorter.setRowFilter((RowFilter)filters.get(0));
            } else {
                FilterTablePanel.this._sorter.setRowFilter(null);
            }
        }
    }

    private class RowData {
        Vector _data;
        int _row;

        RowData(Vector data, int row) {
            this._data = data;
            this._row = row;
        }

        public Vector getData() {
            return this._data;
        }

        public Object get(int col) {
            return this._data.get(col);
        }

        public int getRow() {
            return this._row;
        }

        public void set(int col, Object data) {
            this._data.set(col, data);
        }

        public int size() {
            return this._data.size();
        }
    }

    private class FilterTableModel
    extends AbstractRmaTableModel
    implements RmaTableModelInterface,
    TableModelListener {
        private Map _filters = new HashMap();
        private List _data;
        private boolean _filteringData;
        private RmaTableModelInterface _model;

        public FilterTableModel(RmaTableModelInterface tableModel) {
            this._model = tableModel;
            this._model.addTableModelListener(this);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return this._model.isCellEditable(row, col);
        }

        void setColumnFilter(Object filter, int col) {
            if ("".equals(filter)) {
                this._filters.remove(new Integer(col));
            } else {
                this._filters.put(new Integer(col), filter);
            }
            this.updateDataList();
            if (this._model instanceof AbstractRmaTableModel) {
                ((AbstractRmaTableModel)this._model).fireTableDataChanged();
            }
            this.fireTableDataChanged();
        }

        public Vector getFilteredRows() {
            Vector<Vector> filteredVec = new Vector<Vector>();
            if (this._data != null) {
                for (int i = 0; i < this._data.size(); ++i) {
                    if (!(this._data.get(i) instanceof RowData)) continue;
                    filteredVec.add(((RowData)this._data.get(i)).getData());
                }
            } else {
                filteredVec.addAll(this.getDataVector());
            }
            return filteredVec;
        }

        @Override
        public int getRowCount() {
            int rowCount = this._data == null || this._filteringData ? this._model.getRowCount() : this._data.size();
            return rowCount;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            if (this._data == null) {
                this._model.setValueAt(obj, row, col);
                return;
            }
            RowData rowData = (RowData)this._data.get(row);
            if (rowData == null) {
                return;
            }
            if (col >= rowData.size()) {
                return;
            }
            rowData.set(col, obj);
            this._model.setValueAt(obj, rowData.getRow(), col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this._data == null) {
                return this._model.getValueAt(row, col);
            }
            RowData rowData = (RowData)this._data.get(row);
            if (rowData == null) {
                return null;
            }
            if (col >= rowData.size()) {
                return null;
            }
            return rowData.get(col);
        }

        private void updateDataList() {
            if (this._filters.size() == 0) {
                this._data = null;
                return;
            }
            this._filteringData = true;
            this._data = new ArrayList();
            for (int row = 0; row < this._model.getRowCount(); ++row) {
                Vector rowData = this._model.getRow(row);
                if (rowData == null) continue;
                this.filterRow(rowData, row);
            }
            this._filteringData = false;
        }

        protected void filterRow(Vector rowData, int row) {
            if (this._data == null) {
                return;
            }
            boolean addRow = true;
            for (int col = 0; col < rowData.size(); ++col) {
                Object obj = rowData.get(col);
                Object filter = this._filters.get(new Integer(col));
                if (filter == null) continue;
                String filterString = filter.toString();
                if (filterString != null) {
                    if (WildCardFileFilter.match(filterString, obj.toString())) continue;
                    addRow = false;
                    break;
                }
                if (filter.equals(obj)) continue;
                addRow = false;
                break;
            }
            if (addRow) {
                RowData aRow = new RowData(rowData, row);
                this._data.add(aRow);
            }
        }

        @Override
        public void setColEnabled(boolean enabled, int col) {
            this._model.setColEnabled(enabled, col);
        }

        @Override
        public void setRowEnabled(boolean enabled, int row) {
        }

        @Override
        public void resetRowEnabled() {
        }

        @Override
        public void addColumn(String colName) {
            System.out.println("FilterTableModel.addColumn TODO implement me");
        }

        @Override
        public void addColumn(String columnName, Vector columnData) {
            System.out.println("FilterTableModel.addColumn TODO implement me");
        }

        @Override
        public Vector getDataVector() {
            return this._model.getDataVector();
        }

        @Override
        public void addRow(Vector newRow) {
            this._model.addRow(newRow);
            this.filterRow(newRow, this._model.getRowCount() - 1);
        }

        @Override
        public void insertRow(int row, Vector rowData) {
            this._model.insertRow(row, rowData);
            this.filterRow(rowData, row + 1);
        }

        @Override
        public void insertRows(int row, int cnt, Vector rowData) {
            super.insertRows(row, cnt, rowData);
        }

        @Override
        public void setColumnClass(int col, Class cls) {
            this._model.setColumnClass(col, cls);
        }

        @Override
        public void clearAll() {
            this._model.clearAll();
        }

        @Override
        public void deleteRow(int index) {
            System.out.println("FilterTableModel.deleteRow TODO implement me");
        }

        @Override
        public Vector getRow(int rowNum) {
            if (this._data != null) {
                RowData data = (RowData)this._data.get(rowNum);
                return data.getData();
            }
            return this._model.getRow(rowNum);
        }

        @Override
        public void setColumnNames(String[] colNames) {
            this._model.setColumnNames(colNames);
        }

        @Override
        public void setColumnNames(Vector colNamesVector) {
            this._model.setColumnNames(colNamesVector);
        }

        @Override
        public int getColumnParameter(int col) {
            return this._model.getColumnParameter(col);
        }

        @Override
        public void setColumnParameters(int[] params) {
            this._model.setColumnParameters(params);
        }

        @Override
        public int getUnitSystem() {
            return this._model.getUnitSystem();
        }

        @Override
        public int getGmtOffset() {
            return this._model.getGmtOffset();
        }

        @Override
        public void setDisplayUnitsSystem(int unitSystem) {
            this._model.setDisplayUnitsSystem(unitSystem);
        }

        @Override
        public int getColumnCount() {
            return this._model.getColumnCount();
        }

        @Override
        public Class getColumnClass(int columnIndex) {
            return this._model.getColumnClass(columnIndex);
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this._model.getColumnName(columnIndex);
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this._model.addTableModelListener(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this._model.removeTableModelListener(l);
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.fireTableChanged(e);
        }
    }
}

