/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.GroupableTableHeaderUI;
import rma.swing.table.HeaderPrintCellRendererPane;
import rma.swing.table.PrintUI;
import rma.swing.table.TablePrintProperties;

public class GroupableHeaderPrintUI
extends GroupableTableHeaderUI
implements PrintUI {
    @Override
    public void installUI(JComponent aJComponent) {
        this.header = (GroupableTableHeader)aJComponent;
        this.rendererPane = new HeaderPrintCellRendererPane();
    }

    @Override
    public void setProperties(TablePrintProperties p) {
        if (this.rendererPane instanceof HeaderPrintCellRendererPane) {
            ((HeaderPrintCellRendererPane)this.rendererPane).setPrintProperties(p);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c2) {
        Rectangle clipBounds = g.getClipBounds();
        if (this.header.getColumnModel() == null) {
            return;
        }
        ((GroupableTableHeader)this.header).setColumnMargin();
        int column = 0;
        this.hash.clear();
        Dimension size = this.header.getSize();
        this.cellRect.x = 0;
        this.cellRect.y = 0;
        this.cellRect.setSize(size.width, size.height);
        int columnMargin = this.header.getColumnModel().getColumnMargin();
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        int cMin = this.header.getColumnModel().getColumnIndexAtX(clipBounds.x);
        if (cMin == -1) {
            cMin = 0;
        }
        Vector<ColumnGroup> paintedColumnGroups = new Vector<ColumnGroup>();
        while (enumeration.hasMoreElements()) {
            this.cellRect.height = size.height;
            this.cellRect.y = 0;
            TableColumn aColumn = enumeration.nextElement();
            Enumeration cGroups = ((GroupableTableHeader)this.header).getColumnGroups(aColumn);
            if (cGroups != null) {
                int groupHeight = 0;
                while (cGroups.hasMoreElements()) {
                    ColumnGroup cGroup = (ColumnGroup)cGroups.nextElement();
                    Rectangle groupRect = (Rectangle)this.hash.get(cGroup);
                    if (groupRect == null) {
                        groupRect = new Rectangle(this.cellRect);
                        Dimension d = cGroup.getSize(this.header.getTable(), column);
                        groupRect.width = d.width;
                        groupRect.height = d.height;
                        this.hash.put(cGroup, groupRect);
                    }
                    Rectangle tempRect = new Rectangle(groupRect);
                    if (column != cMin) {
                        --tempRect.x;
                        ++tempRect.width;
                    }
                    ++tempRect.height;
                    if (!paintedColumnGroups.contains(cGroup)) {
                        this.paintCell(g, tempRect, cGroup, column);
                    }
                    this.cellRect.height = size.height - (groupHeight += groupRect.height);
                    this.cellRect.y = groupHeight;
                    paintedColumnGroups.addElement(cGroup);
                }
            }
            this.cellRect.width = aColumn.getWidth();
            if (this.cellRect.intersects(clipBounds)) {
                Rectangle tempRect = new Rectangle(this.cellRect);
                if (Boolean.getBoolean("PRINT_DEBUG")) {
                    System.out.println("Groupable Table Header Clip Bounds = " + clipBounds);
                    System.out.println("Groupable Table Header CellRect    = " + clipBounds);
                    System.out.println("Column Index = " + column);
                }
                if (column != cMin) {
                    --tempRect.x;
                    ++tempRect.width;
                }
                ++tempRect.height;
                this.paintCell(g, tempRect, column);
            }
            this.cellRect.x += this.cellRect.width;
            ++column;
        }
    }

    @Override
    protected void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null && (renderer = this.header.getTable().getTableHeader().getDefaultRenderer()) == null) {
            System.out.println("paintCell: null renderer for column " + columnIndex);
            return;
        }
        Component component = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }
}

