/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.UIManager;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeaderUI;
import rma.swing.table.ToolTipHeader;

public class GroupableTableHeader
extends ToolTipHeader {
    private static final String uiClassID = "GroupableTableHeaderUI";
    protected Vector columnGroups = null;
    private boolean _drawTableCol;
    private boolean _drawTableColumnHeaders = true;

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public GroupableTableHeader(TableColumnModel model) {
        super(model);
        this.setReorderingAllowed(false);
    }

    @Override
    public void setReorderingAllowed(boolean b) {
        this.reorderingAllowed = false;
    }

    public void addColumnGroup(ColumnGroup g) {
        if (this.columnGroups == null) {
            this.columnGroups = new Vector();
        }
        this.columnGroups.addElement(g);
    }

    public void removeColumnGroup(ColumnGroup g) {
        if (this.columnGroups == null) {
            return;
        }
        if (g == null) {
            return;
        }
        this.columnGroups.removeElement(g);
    }

    public int getNumberOfColumnGroups() {
        if (this.columnGroups == null) {
            return -1;
        }
        return this.columnGroups.size();
    }

    public Vector getColumnGroups() {
        if (this.columnGroups == null) {
            return null;
        }
        return (Vector)this.columnGroups.clone();
    }

    public void removeAllColumnGroups() {
        if (this.columnGroups == null) {
            return;
        }
        this.columnGroups.removeAllElements();
    }

    public ColumnGroup getColumnGroup(int idx) {
        return (ColumnGroup)this.columnGroups.get(idx);
    }

    public int getColumnGroupCount(Object col) {
        if (this.columnGroups == null) {
            return 0;
        }
        Enumeration enumeration = this.columnGroups.elements();
        while (enumeration.hasMoreElements()) {
            ColumnGroup cGroup = (ColumnGroup)enumeration.nextElement();
            Vector v_ret = cGroup.getColumnGroups(col, new Vector());
            if (v_ret == null) continue;
            return v_ret.size();
        }
        return 0;
    }

    public Enumeration getColumnGroups(TableColumn col) {
        if (this.columnGroups == null) {
            return null;
        }
        Enumeration enumeration = this.columnGroups.elements();
        while (enumeration.hasMoreElements()) {
            ColumnGroup cGroup = (ColumnGroup)enumeration.nextElement();
            Vector v_ret = cGroup.getColumnGroups(col, new Vector());
            if (v_ret == null) continue;
            return v_ret.elements();
        }
        return null;
    }

    public void setColumnMargin() {
        if (this.columnGroups == null) {
            return;
        }
        int columnMargin = this.getColumnModel().getColumnMargin();
        Enumeration enumeration = this.columnGroups.elements();
        while (enumeration.hasMoreElements()) {
            ColumnGroup cGroup = (ColumnGroup)enumeration.nextElement();
            cGroup.setColumnMargin(columnMargin);
        }
    }

    public Rectangle getColumnGroupSize(int columnGroupIndex) {
        ColumnGroup cg = this.getColumnGroup(columnGroupIndex);
        TableHeaderUI ui = this.getUI();
        if (ui instanceof GroupableTableHeaderUI) {
            return ((GroupableTableHeaderUI)ui).getColumnGroupSize(cg);
        }
        return null;
    }

    public void setDrawTableColumnHeaders(boolean drawHeaders) {
        this._drawTableColumnHeaders = drawHeaders;
    }

    public boolean shouldDrawTableColumnHeaders() {
        return this._drawTableColumnHeaders;
    }

    static {
        UIManager.put(uiClassID, "rma.swing.table.GroupableTableHeaderUI");
    }
}

