/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;

public class GroupableTableHeaderUI
extends BasicTableHeaderUI {
    protected HashMap hash = new HashMap();
    protected Rectangle cellRect = new Rectangle(0, 0);

    public static ComponentUI createUI(JComponent h) {
        return new GroupableTableHeaderUI();
    }

    @Override
    public void paint(Graphics g, JComponent c2) {
        Rectangle clipBounds = g.getClipBounds();
        if (this.header.getColumnModel() == null) {
            return;
        }
        ((GroupableTableHeader)this.header).setColumnMargin();
        int column = 0;
        this.hash.clear();
        Dimension size = this.header.getSize();
        this.cellRect.x = 0;
        this.cellRect.y = 0;
        this.cellRect.setSize(size.width, size.height);
        int columnMargin = this.header.getColumnModel().getColumnMargin();
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        Vector<ColumnGroup> paintedColumnGroups = new Vector<ColumnGroup>();
        while (enumeration.hasMoreElements()) {
            this.cellRect.height = size.height;
            this.cellRect.y = 0;
            TableColumn aColumn = enumeration.nextElement();
            Enumeration cGroups = ((GroupableTableHeader)this.header).getColumnGroups(aColumn);
            if (cGroups != null) {
                int groupHeight = 0;
                while (cGroups.hasMoreElements()) {
                    ColumnGroup cGroup = (ColumnGroup)cGroups.nextElement();
                    Rectangle groupRect = (Rectangle)this.hash.get(cGroup);
                    if (groupRect == null) {
                        groupRect = new Rectangle(this.cellRect);
                        Dimension d = cGroup.getSize(this.header.getTable(), column);
                        groupRect.width = d.width;
                        groupRect.height = d.height;
                        this.hash.put(cGroup, groupRect);
                    }
                    if (!paintedColumnGroups.contains(cGroup)) {
                        this.paintCell(g, groupRect, cGroup, column);
                    }
                    this.cellRect.height = size.height - (groupHeight += groupRect.height);
                    this.cellRect.y = groupHeight;
                    paintedColumnGroups.addElement(cGroup);
                }
            }
            this.cellRect.width = aColumn.getWidth();
            if (this.cellRect.intersects(clipBounds)) {
                this.paintCell(g, this.cellRect, column);
            }
            this.cellRect.x += this.cellRect.width;
            ++column;
        }
    }

    public Rectangle getColumnGroupSize(ColumnGroup cGroup) {
        Rectangle groupRect = (Rectangle)this.hash.get(cGroup);
        int column = 0;
        if (groupRect == null) {
            groupRect = new Rectangle(this.cellRect);
            Dimension d = cGroup.getSize(this.header.getTable(), column);
            groupRect.width = d.width;
            groupRect.height = d.height;
            this.hash.put(cGroup, groupRect);
        }
        Dimension size = this.header.getSize();
        int groupHeight = groupRect.height;
        this.cellRect.height = size.height - groupHeight;
        this.cellRect.y = groupHeight;
        return (Rectangle)this.cellRect.clone();
    }

    protected void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        if (!((GroupableTableHeader)this.header).shouldDrawTableColumnHeaders()) {
            return;
        }
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null && (renderer = this.header.getTable().getTableHeader().getDefaultRenderer()) == null) {
            System.out.println("paintCell: null renderer for column " + columnIndex);
            return;
        }
        Component component = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    protected void paintCell(Graphics g, Rectangle cellRect, ColumnGroup cGroup, int columnIndex) {
        TableCellRenderer renderer = cGroup.getHeaderRenderer();
        Component component = renderer.getTableCellRendererComponent(this.header.getTable(), cGroup.getHeaderValue(), false, false, -1, columnIndex);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private int getHeaderHeight() {
        int height = 0;
        TableColumnModel columnModel = this.header.getColumnModel();
        for (int column = 0; column < columnModel.getColumnCount(); ++column) {
            Enumeration enumeration;
            TableColumn aColumn = columnModel.getColumn(column);
            TableCellRenderer renderer = aColumn.getHeaderRenderer();
            if (renderer == null) {
                JTable table = this.header.getTable();
                if (table == null) {
                    System.out.println("getHeaderHeight: null table for column " + column);
                    continue;
                }
                renderer = table.getTableHeader().getDefaultRenderer();
                if (renderer == null) {
                    System.out.println("getHeaderHeight: null renderer for column " + column);
                    continue;
                }
            }
            Component comp = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, column);
            int cHeight = comp.getPreferredSize().height;
            if (!((GroupableTableHeader)this.header).shouldDrawTableColumnHeaders()) {
                cHeight = 0;
            }
            if ((enumeration = ((GroupableTableHeader)this.header).getColumnGroups(aColumn)) != null) {
                while (enumeration.hasMoreElements()) {
                    ColumnGroup cGroup = (ColumnGroup)enumeration.nextElement();
                    cHeight += cGroup.getSize((JTable)this.header.getTable(), (int)column).height;
                }
            }
            height = Math.max(height, cHeight);
        }
        return height;
    }

    private Dimension createHeaderSize(long width) {
        TableColumnModel columnModel = this.header.getColumnModel();
        if ((width += (long)(columnModel.getColumnMargin() * columnModel.getColumnCount())) > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, this.getHeaderHeight());
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createHeaderSize(width);
    }
}

